/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.classfinal.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.roseboy.classfinal.Constants;
import net.roseboy.classfinal.util.IoUtils;

public class JarUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doJar(String jarDir, String targetJar) {
        ArrayList<File> files = new ArrayList<File>();
        IoUtils.listFile(files, new File(jarDir));
        ZipOutputStream zos = null;
        FileOutputStream out = null;
        try {
            File jar = new File(targetJar);
            if (jar.exists()) {
                jar.delete();
            }
            out = new FileOutputStream(jar);
            zos = new ZipOutputStream(out);
            for (File file : files) {
                ZipEntry ze;
                if (JarUtils.isDel(file)) continue;
                String fileName = file.getAbsolutePath().substring(jarDir.length());
                String string = fileName = (fileName = fileName.replace(File.separator, "/")).startsWith("/") ? fileName.substring(1) : fileName;
                if (file.isDirectory()) {
                    ze = new ZipEntry(fileName + "/");
                    ze.setTime(System.currentTimeMillis());
                    zos.putNextEntry(ze);
                    zos.closeEntry();
                    continue;
                }
                if (fileName.endsWith(".jar")) {
                    byte[] bytes = IoUtils.readFileToByte(file);
                    ZipEntry ze2 = new ZipEntry(fileName);
                    ze2.setMethod(0);
                    ze2.setSize(bytes.length);
                    ze2.setTime(System.currentTimeMillis());
                    ze2.setCrc(IoUtils.crc32(bytes));
                    zos.putNextEntry(ze2);
                    zos.write(bytes);
                    zos.closeEntry();
                    continue;
                }
                ze = new ZipEntry(fileName);
                ze.setTime(System.currentTimeMillis());
                zos.putNextEntry(ze);
                byte[] bytes = IoUtils.readFileToByte(file);
                zos.write(bytes);
                zos.closeEntry();
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.close(zos, out);
                throw throwable;
            }
            IoUtils.close(zos, out);
        }
        IoUtils.close(zos, out);
        return targetJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> unJar(String jarPath, String targetDir, List<String> includeJars) {
        ArrayList<String> list = new ArrayList<String>();
        File targetDirs = new File(targetDir = targetDir.endsWith("/") ? targetDir.substring(0, targetDir.length() - 1) : targetDir);
        if (!targetDirs.exists()) {
            targetDirs.mkdirs();
        }
        Object fin = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(new File(jarPath));
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                byte[] bytes;
                ZipEntry entry = entries.nextElement();
                list.add(targetDir + "/" + entry.getName());
                if (entry.getName().endsWith(".jar")) {
                    bytes = IoUtils.toByteArray(zipFile.getInputStream(entry));
                    IoUtils.writeFile(new File(targetDir + "/" + entry.getName()), bytes);
                    String jarName = entry.getName().replace("BOOT-INF/lib/", "");
                    jarName = jarName.replace("WEB-INF/lib/", "");
                    if (includeJars != null && includeJars.size() != 0 && !includeJars.contains(jarName)) continue;
                    String targetPath0 = targetDir + "/" + entry.getName();
                    String targetDir0 = targetDir + "/" + entry.getName().replace(".jar", "_temp");
                    List<String> list0 = JarUtils.unJar(targetPath0, targetDir0, includeJars);
                    list.addAll(list0);
                    continue;
                }
                if (entry.isDirectory()) {
                    File dir = new File(targetDir + "/" + entry.getName());
                    if (dir.exists()) continue;
                    dir.mkdirs();
                    continue;
                }
                bytes = IoUtils.toByteArray(zipFile.getInputStream(entry));
                IoUtils.writeFile(new File(targetDir + "/" + entry.getName()), bytes);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.close(zipFile, fin);
                throw throwable;
            }
            IoUtils.close(zipFile, fin);
        }
        IoUtils.close(zipFile, fin);
        return list;
    }

    public static String releaseFileFromJar(File zip, String fileName, File targetFile) {
        byte[] bytes = JarUtils.getFileFromJar(zip, fileName);
        if (bytes == null) {
            return null;
        }
        IoUtils.writeFile(targetFile, bytes);
        return targetFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] getFileFromJar(File zip, String fileName) {
        byte[] byArray;
        ZipEntry zipEntry;
        ZipFile zipFile;
        block7: {
            block6: {
                zipFile = null;
                if (zip.exists()) break block6;
                byte[] byArray2 = null;
                IoUtils.close(zipFile);
                return byArray2;
            }
            zipFile = new ZipFile(zip);
            zipEntry = zipFile.getEntry(fileName);
            if (zipEntry != null) break block7;
            byte[] byArray3 = null;
            IoUtils.close(zipFile);
            return byArray3;
        }
        try {
            InputStream is = zipFile.getInputStream(zipEntry);
            byArray = IoUtils.toByteArray(is);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.close(zipFile);
                throw throwable;
            }
            IoUtils.close(zipFile);
            return null;
        }
        IoUtils.close(zipFile);
        return byArray;
    }

    public static boolean isDel(File file) {
        for (String f : Constants.DLE_FILES) {
            if (!file.getAbsolutePath().endsWith(f)) continue;
            return true;
        }
        return false;
    }
}

