package net.roseboy.filereview.util;

import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeManager;

import java.io.File;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * 利用openoffice将word转成pdf
 *
 * @author guoruikai
 */
public class OfficeToPdfUtils {
    private static OfficeManager officeManager;
    public static Queue<String> QUEUELIST = new ConcurrentLinkedQueue<String>();
    private static boolean running = false;
    private static String office_home = "/Applications/OpenOffice.app/Contents/";


    public static void toPdfThread(String file) {
        synchronized (QUEUELIST) {
            QUEUELIST.offer(file);// 把文件路径加入队列
        }
        if (!isRunning()) {// 如果转换线程没有运行，那么重新启动线程
            ToPdfThread t = new ToPdfThread();
            t.start();
        }
    }

    public static void toPDF(String file) {
        try {
            String ext = file.substring(file.lastIndexOf(".") + 1).toLowerCase();
            if ("doc,docx,ppt,pptx,xls,xlsx".contains(ext)) {
                convert2PDF(file, file + ".pdf");
            }
        } catch (Exception e) {
            clearQueue();//报错就不干
            e.printStackTrace();
        }
    }

    public static void convert2PDF(String inputFile, String pdfFile) {
        startService();
        OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
        converter.convert(new File(inputFile), new File(pdfFile));
        stopService();
    }

    public static void startService() {
        DefaultOfficeManagerConfiguration configuration = new DefaultOfficeManagerConfiguration();
        try {
            // 准备启动服务
            configuration.setOfficeHome(office_home);// 设置OpenOffice.org安装目录
            // 设置转换端口，默认为8100
            configuration.setPortNumbers(8100);
            // 设置任务执行超时为5分钟
            configuration.setTaskExecutionTimeout(1000 * 60 * 5L);
            // 设置任务队列超时为24小时
            configuration.setTaskQueueTimeout(1000 * 60 * 60 * 24L);
            officeManager = configuration.buildOfficeManager();
            officeManager.start(); // 启动服务
        } catch (Exception ce) {
            ce.printStackTrace();
        }
    }

    public static void stopService() {
        if (officeManager != null) {
            officeManager.stop();
        }
    }

    public static void setOfficeHome(String home) {
        office_home = home;
    }

    public synchronized static void setRunning(boolean r) {
        running = r;
    }

    public synchronized static boolean isRunning() {
        return running;
    }

    public synchronized static void clearQueue() {
        QUEUELIST.clear();
    }

    public static void main(String[] args) {
        convert2PDF("C:\\Users\\roseboy\\Desktop\\口腔医院开发方案-版24.docx",
                "C:\\Users\\roseboy\\Desktop\\1.pdf");
    }
}
