package net.roseboy.filereview.util;

import org.apache.commons.lang3.StringUtils;

public class ToPdfThread extends Thread {

    public ToPdfThread() {

    }

    @Override
    public void run() {
        OfficeToPdfUtils.setRunning(true);
        System.out.println("Office转换线程开启");

        String path = "";
        synchronized (OfficeToPdfUtils.QUEUELIST) {
            path = OfficeToPdfUtils.QUEUELIST.poll();
        }
        while (StringUtils.isNotEmpty(path)) {
            System.out.println("还剩" + (OfficeToPdfUtils.QUEUELIST.size() + 1) + "个待转换");
            OfficeToPdfUtils.toPDF(path);
            synchronized (OfficeToPdfUtils.QUEUELIST) {
                path = OfficeToPdfUtils.QUEUELIST.poll();
            }
        }
        System.out.println("Office转换线程结束");
        OfficeToPdfUtils.setRunning(false);
    }
}
