package net.roseboy.filereview.web;

import net.roseboy.filereview.util.OfficeToPdfUtils;
import net.roseboy.jeee.core.common.BaseJeeeController;
import net.roseboy.jeee.core.util.SpringUtils;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * 文件预览的接口
 *
 * @author roseboy
 */
@Controller
@RequestMapping("admin/review")
public class ReviewController extends BaseJeeeController {
    @Value("${jeee.upload-path}")
    private String uploadPath;
    @Value("${jeee.openoffice}")
    private String openoffice;

    @RequestMapping("view")
    private String view(String id, String path) throws UnsupportedEncodingException {
        OfficeToPdfUtils.setOfficeHome(openoffice);
        String uploadPath = this.uploadPath;
        // 上传文件路径
        if (!uploadPath.endsWith("/")) {
            uploadPath += "/";
        }
        echo(openoffice);

        String downloadUrl = getAttr("root") + "/admin/attachment/downloadByPath?downPath=";
        String ext = path.substring(path.lastIndexOf(".") + 1).toLowerCase();
        if ("doc,docx,ppt,pptx,xls,xlsx".contains(ext)) {// office
            File pdfFile = new File(uploadPath + path + ".pdf");
            if (pdfFile.exists()) {
                return "redirect:/review/pdfjs/web/viewer.html?file=" + URLEncoder.encode(downloadUrl + path + ".pdf", "utf-8");
            } else {
                if (!OfficeToPdfUtils.QUEUELIST.contains(uploadPath + path)) {
                    OfficeToPdfUtils.toPdfThread(uploadPath + path);
                }
                return "review/wait";// 等待转换
            }
        } else if ("jpg,jpeg,gif,png,bmp".contains(ext)) {// 图片
            setAttr("img", downloadUrl + path);
            return "review/pic";
        } else if ("txt,java,php,css,js,html,htm".contains(ext)) {// 文本
            try {
                setAttr("text", FileUtils.readFileToString(new File(uploadPath + path), "utf-8"));
            } catch (IOException e) {
            }
            return "review/text";
        } else if ("mp3,mp4".contains(ext)) {// 多媒体文件
            setAttr("mediaUrl", downloadUrl + path);
            return "review/media";
        } else if ("pdf".contains(ext)) {// pdf
            return "redirect:/review/pdfjs/web/viewer.html?file=" + URLEncoder.encode(downloadUrl + path, "utf-8");
        } else {
            setAttr("download", downloadUrl + path);
            setAttr("fileType", ext);
            return "review/notview";
        }
    }
}
