/*
 * Decompiled with CFR 0.152.
 */
package jfinal.plugin.shiro;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.kit.StrKit;
import jfinal.plugin.shiro.AuthzHandler;
import jfinal.plugin.shiro.ShiroKit;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthenticatedException;

public class ShiroInterceptor
implements Interceptor {
    public void intercept(Invocation ai) {
        AuthzHandler ah = ShiroKit.getAuthzHandler(ai.getActionKey());
        if (ah != null) {
            try {
                ah.assertAuthorized();
            }
            catch (UnauthenticatedException lae) {
                if (StrKit.notBlank((String)ShiroKit.getLoginUrl())) {
                    if (ai.getController().getRequest().getMethod().equalsIgnoreCase("GET")) {
                        ai.getController().setSessionAttr(ShiroKit.getSavedRequestKey(), (Object)ai.getActionKey());
                    }
                    ai.getController().redirect(ShiroKit.getLoginUrl() + "?url=" + ai.getActionKey());
                } else {
                    ai.getController().renderError(401);
                }
                return;
            }
            catch (AuthorizationException ae) {
                if (StrKit.notBlank((String)ShiroKit.getUnauthorizedUrl())) {
                    ai.getController().redirect(ShiroKit.getUnauthorizedUrl() + "?url=" + ai.getActionKey());
                } else {
                    ai.getController().renderError(403);
                }
                return;
            }
        }
        ai.invoke();
    }
}

