/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.core;

import com.jfinal.plugin.activerecord.Db;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.roseboy.framework.core.KModel;
import net.roseboy.framework.core.KPage;

public class KDb
extends Db {
    private static KModel<?> kmodel = new KModel();

    public static KPage findPage(KPage kpage, String sql) {
        return kmodel.findPage(kpage, sql);
    }

    public static List<Map<String, Object>> find(KPage kpage, String sql) {
        return kmodel.find(kpage, sql);
    }

    public static void closeDB(Object ... param) {
        if (param != null) {
            for (Object obj : param) {
                try {
                    if (obj instanceof ResultSet) {
                        ((ResultSet)obj).close();
                    }
                    if (obj instanceof PreparedStatement) {
                        ((PreparedStatement)obj).close();
                    }
                    if (!(obj instanceof Connection)) continue;
                    ((Connection)obj).close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void setParam(PreparedStatement pst, Object ... param) {
        int length = param.length;
        for (int i = 0; i < length; ++i) {
            try {
                pst.setObject(i + 1, param[i]);
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static List<Map<String, Object>> convertList(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        while (rs.next()) {
            LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
            for (int i = 1; i <= columnCount; ++i) {
                rowData.put(md.getColumnName(i), rs.getObject(i));
            }
            list.add(rowData);
        }
        return list;
    }

    public static List<Map<String, Object>> exeQuery(Connection conn, String sql, Object ... param) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            PreparedStatement perstmp = conn.prepareStatement(sql);
            KDb.setParam(perstmp, param);
            ResultSet rs = perstmp.executeQuery();
            list = KDb.convertList(rs);
            KDb.closeDB(rs, perstmp);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Map<String, String> getMetaData(Connection conn, String tab) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select * from " + tab);
            ResultSetMetaData meta = rs.getMetaData();
            String type = "";
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                type = meta.getColumnClassName(i);
                type = meta.getColumnClassName(i).substring(type.lastIndexOf(".") + 1);
                if ("Timestamp".equals(type)) {
                    type = "Date";
                }
                map.put(meta.getColumnName(i), type);
            }
            KDb.closeDB(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }
}

