/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.core;

import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.Table;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.roseboy.framework.core.JFinalUtils;
import net.roseboy.framework.core.KPage;
import net.roseboy.framework.util.IdKit;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;

public class KModel<T extends Model<T>>
extends Model<T> {
    private static final long serialVersionUID = 1L;

    private String makeWhereSql(List<Object> resultList, LinkedHashMap<String, Object> whereMap, Boolean checkCol) {
        StringBuffer whereSql = new StringBuffer();
        whereSql.append("WHERE 1=1");
        for (Map.Entry<String, Object> entry : whereMap.entrySet()) {
            String[] ks = entry.getKey().split("\\.");
            String k1 = ks[0];
            String k2 = ks[1];
            if ("EQ".equalsIgnoreCase(k1)) {
                whereSql.append(" AND (" + this.makeWhereSql(k2, resultList, "=", entry.getValue(), checkCol) + ")");
                continue;
            }
            if ("LIKE".equalsIgnoreCase(k1)) {
                whereSql.append(" AND (" + this.makeWhereSql(k2, resultList, "LIKE", entry.getValue(), checkCol) + ")");
                continue;
            }
            if ("NE".equalsIgnoreCase(k1)) {
                whereSql.append(" AND (" + this.makeWhereSql(k2, resultList, "!=", entry.getValue(), checkCol) + ")");
                continue;
            }
            if ("LT".equalsIgnoreCase(k1)) {
                whereSql.append(" AND (" + this.makeWhereSql(k2, resultList, "<", entry.getValue(), checkCol) + ")");
                continue;
            }
            if ("GT".equalsIgnoreCase(k1)) {
                whereSql.append(" AND (" + this.makeWhereSql(k2, resultList, ">", entry.getValue(), checkCol) + ")");
                continue;
            }
            if ("LE".equalsIgnoreCase(k1)) {
                whereSql.append(" AND (" + this.makeWhereSql(k2, resultList, "<=", entry.getValue(), checkCol) + ")");
                continue;
            }
            if ("GE".equalsIgnoreCase(k1)) {
                whereSql.append(" AND (" + this.makeWhereSql(k2, resultList, ">=", entry.getValue(), checkCol) + ")");
                continue;
            }
            if ("IN".equalsIgnoreCase(k1)) {
                whereSql.append(" AND (" + this.makeWhereSql(k2, resultList, "IN", entry.getValue(), checkCol) + ")");
                continue;
            }
            if (!"NOTIN".equalsIgnoreCase(k1)) continue;
            whereSql.append(" AND (" + this.makeWhereSql(k2, resultList, "NOT IN", entry.getValue(), checkCol) + ")");
        }
        System.out.println(resultList);
        return whereSql.toString();
    }

    private String makeWhereSql(String where, List<Object> resultList, String eq, Object value, Boolean checkCol) {
        Table table = null;
        if (checkCol.booleanValue()) {
            table = JFinalUtils.getTable(super.getClass());
        }
        StringBuffer whereSql = new StringBuffer();
        if ((where = where.replace("(", "").replace(")", "")).contains(",")) {
            String[] wheres;
            for (String w : wheres = where.split(",")) {
                w = JFinalUtils.toDbName(w);
                if ((checkCol.booleanValue() || !this.CheckSqlCol(w).booleanValue()) && (!checkCol.booleanValue() || !table.hasColumnLabel(w))) continue;
                whereSql.append("OR " + w + " " + eq + " ? ");
                if ("like".equalsIgnoreCase(eq)) {
                    resultList.add("%" + value + "%");
                    continue;
                }
                resultList.add(value);
            }
        } else {
            where = JFinalUtils.toDbName(where);
            if (table == null || table.hasColumnLabel(where)) {
                if ("like".equalsIgnoreCase(eq)) {
                    whereSql.append("OR " + where + " " + eq + " ? ");
                    resultList.add("%" + value + "%");
                } else if ("in".equalsIgnoreCase(eq) || "not in".equalsIgnoreCase(eq)) {
                    whereSql.append("   ");
                    if (value.getClass().isArray()) {
                        Object[] values = (Object[])value;
                        if (values.length > 0) {
                            whereSql.append(where + " " + eq + " (");
                            for (Object v : values) {
                                resultList.add(v);
                                whereSql.append("?,");
                            }
                            whereSql.deleteCharAt(whereSql.length() - 1);
                        } else {
                            whereSql.append("(1=1");
                        }
                    } else if (value instanceof List) {
                        List values = (List)value;
                        if (values.size() > 0) {
                            whereSql.append(where + " " + eq + " (");
                            for (Object v : values) {
                                resultList.add(v);
                                whereSql.append("?,");
                            }
                            whereSql.deleteCharAt(whereSql.length() - 1);
                        } else {
                            whereSql.append("(1=1");
                        }
                    } else {
                        whereSql.append("(1=1");
                    }
                    whereSql.append(")");
                } else {
                    whereSql.append("OR " + where + " " + eq + " ? ");
                    resultList.add(value);
                }
            }
        }
        whereSql.delete(0, 3);
        if (StringUtils.isEmpty((CharSequence)whereSql.toString().trim())) {
            whereSql.append("1=1");
        }
        return whereSql.toString();
    }

    private String makeOrderSql(LinkedHashMap<String, String> orderMap, Boolean checkCol) {
        Table table = null;
        if (checkCol.booleanValue()) {
            table = JFinalUtils.getTable(super.getClass());
        }
        StringBuffer orderSql = new StringBuffer();
        orderSql.append(" ");
        for (Map.Entry<String, String> entry : orderMap.entrySet()) {
            String colname = entry.getKey();
            colname = JFinalUtils.toDbName(colname);
            if ((checkCol.booleanValue() || !this.CheckSqlCol(colname).booleanValue()) && (!checkCol.booleanValue() || !table.hasColumnLabel(colname)) || !"asc".equals(entry.getValue().toLowerCase()) && !"desc".equals(entry.getValue().toLowerCase())) continue;
            orderSql.append("`");
            orderSql.append(colname);
            orderSql.append("` ");
            orderSql.append(entry.getValue());
            orderSql.append(",");
        }
        orderSql.deleteCharAt(orderSql.length() - 1);
        if (orderSql.length() > 0) {
            orderSql.insert(0, " ORDER BY");
        }
        return orderSql.toString();
    }

    public KPage<T> findPage(KPage<T> kpage) {
        ArrayList<Object> paraList = new ArrayList<Object>();
        String whereSql = this.makeWhereSql(paraList, kpage.getWhere(), true);
        String orderSql = this.makeOrderSql(kpage.getOrder(), true);
        String table = JFinalUtils.getTable(super.getClass()).getName();
        Page p = this.paginate(kpage.getPageNo(), kpage.getPageSize(), "SELECT *", "FROM " + table + " " + whereSql + orderSql, paraList.toArray());
        kpage.setRows(p.getList());
        kpage.setTotal(p.getTotalRow());
        kpage.setPageCount(p.getTotalPage());
        return kpage;
    }

    public KPage<Map<String, Object>> findPage(KPage<Map<String, Object>> kpage, String sql) {
        ArrayList<Object> paraList = new ArrayList<Object>();
        String whereSql = this.makeWhereSql(paraList, kpage.getWhere(), false);
        String orderSql = this.makeOrderSql(kpage.getOrder(), false);
        Page page = Db.paginate((int)kpage.getPageNo(), (int)kpage.getPageSize(), (String)"SELECT *", (String)("FROM (" + sql + ") _tab " + whereSql + orderSql), (Object[])paraList.toArray());
        ArrayList<Map> list = new ArrayList<Map>();
        for (Record r : page.getList()) {
            list.add(r.getColumns());
        }
        kpage.setRows(list);
        kpage.setTotal(page.getTotalRow());
        kpage.setPageCount(page.getTotalPage());
        return kpage;
    }

    public List<T> find(KPage<T> kpage) {
        ArrayList<Object> paraList = new ArrayList<Object>();
        String whereSql = this.makeWhereSql(paraList, kpage.getWhere(), true);
        String orderSql = this.makeOrderSql(kpage.getOrder(), true);
        String table = JFinalUtils.getTable(super.getClass()).getName();
        List list = this.find("SELECT * FROM " + table + " " + whereSql + orderSql, paraList.toArray());
        kpage.setRows(list);
        kpage.setTotal(list.size());
        return list;
    }

    public List<Map<String, Object>> find(KPage<Map<String, Object>> kpage, String sql) {
        ArrayList<Object> paraList = new ArrayList<Object>();
        String whereSql = this.makeWhereSql(paraList, kpage.getWhere(), false);
        String orderSql = this.makeOrderSql(kpage.getOrder(), false);
        List list = Db.find((String)("SELECT * FROM (" + sql + ") _tab " + whereSql + orderSql), (Object[])paraList.toArray());
        ArrayList<Map<String, Object>> rlist = new ArrayList<Map<String, Object>>();
        for (Record r : list) {
            rlist.add(r.getColumns());
        }
        kpage.setRows(rlist);
        kpage.setTotal(rlist.size());
        return rlist;
    }

    public T findFirst(KPage<T> kpage) {
        ArrayList<Object> paraList = new ArrayList<Object>();
        String whereSql = this.makeWhereSql(paraList, kpage.getWhere(), true);
        String orderSql = this.makeOrderSql(kpage.getOrder(), true);
        String table = JFinalUtils.getTable(super.getClass()).getName();
        return (T)this.findFirst("SELECT * FROM `" + table + "` " + whereSql + orderSql + " LIMIT 1", paraList.toArray());
    }

    public List<T> findAll() {
        String table = JFinalUtils.getTable(super.getClass()).getName();
        return this.find("SELECT * FROM " + table + "");
    }

    public boolean saveOrUpdate() {
        String pk = JFinalUtils.getTable(((Object)((Object)this)).getClass()).getPrimaryKey()[0];
        if (null == this.get(pk)) {
            return this.save();
        }
        return this.update();
    }

    private Boolean CheckSqlCol(String sql) {
        String[] no = new String[]{" ", ",", "`", "'", "=", "select"};
        sql = sql == null ? "" : sql;
        sql = sql.toLowerCase();
        for (String s : no) {
            if (!sql.contains(s)) continue;
            return false;
        }
        return true;
    }

    public String makeSomeChar(int count) {
        if (count <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public int deleteByProperty(String property, Object value) {
        String table = JFinalUtils.getTable(super.getClass()).getName();
        String sql = "DELETE FROM " + table + " WHERE " + property + " = ?";
        return Db.update((String)sql, (Object[])new Object[]{value});
    }

    public boolean saveOrUpdate2() {
        Table table = JFinalUtils.getTable(((Object)((Object)this)).getClass());
        String pk = JFinalUtils.getTable(((Object)((Object)this)).getClass()).getPrimaryKey()[0];
        if (null == this.get(pk)) {
            this.set(pk, IdKit.UUID());
            if (table.hasColumnLabel("create_by")) {
                this.set("create_date", new Date());
                this.set("update_date", new Date());
                this.set("create_by", KModel.getLoginUsername());
                this.set("update_by", KModel.getLoginUsername());
            }
            return this.save();
        }
        if (table.hasColumnLabel("update_date")) {
            this.set("update_date", new Date());
            this.set("update_by", KModel.getLoginUsername());
        }
        return this.update();
    }

    public static String getLoginUsername() {
        String user = "";
        try {
            Session session = SecurityUtils.getSubject().getSession();
            user = (String)session.getAttribute((Object)"C_USER_NAME");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return user;
    }
}

