/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.jfinal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.roseboy.framework.core.JFinalUtils;
import net.roseboy.framework.core.KDb;

public class JfinalModelGenerator {
    public static final String user = "root";
    public static final String pass = "root";
    public static final String server = "127.0.0.1:3306";
    public static final String DbName = "test";
    public static final String PackageName = "net.roseboy.project.model";
    public static final String Path = "D:\\";

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("tb_planter,Planter,\u573a\u533a\u4eba\u5458Model");
        JfinalModelGenerator.go(list, true);
    }

    public static void go(List<String> list, boolean override) {
        Connection conn = JfinalModelGenerator.getConnection();
        for (String s : list) {
            String[] ss = s.split(",");
            JfinalModelGenerator.makeCode(conn, DbName, ss[0], ss[1], ss[2]);
        }
    }

    private static void makeCode(Connection conn, String db, String tb, String cls, String memo) {
        StringBuffer code = new StringBuffer();
        code.append("package net.roseboy.project.model.base;\n");
        code.append("\n");
        code.append("import java.util.Date;\n");
        code.append("import java.math.BigInteger;\n");
        code.append("import java.math.BigDecimal;\n");
        code.append("import com.jfinal.plugin.activerecord.IBean;\n");
        code.append("import net.roseboy.framework.core.KModel; \n\n");
        code.append("//\u81ea\u52a8\u751f\u6210\uff0c\u8bf7\u52ff\u66f4\u6539\n");
        code.append("//" + memo + "\n");
        code.append("public abstract class Base" + cls + "<M extends Base" + cls + "<M>> extends KModel<M> implements IBean {\n");
        code.append("\tprivate static final long serialVersionUID = 1L; \n");
        code.append("\n");
        Map<String, String> mapType = KDb.getMetaData(conn, db + "." + tb);
        Map<String, String> mapRem = JfinalModelGenerator.getRemData(conn, tb, db);
        for (Map.Entry<String, String> entry : mapType.entrySet()) {
            code.append("\tprivate " + entry.getValue() + " " + JFinalUtils.toJavaName(entry.getKey(), null) + ";//" + mapRem.get(entry.getKey()) + "\n");
        }
        code.append("\n");
        String ctype = "";
        String cname = "";
        for (Map.Entry<String, String> entry : mapType.entrySet()) {
            cname = entry.getKey();
            ctype = entry.getValue();
            System.out.println(cname + "==>" + ctype);
            code.append("\tpublic void " + JFinalUtils.toJavaName(cname, "set") + "(" + ctype + " " + cname + "){\n");
            code.append("\t\tthis." + JFinalUtils.toJavaName(cname, null) + " = " + cname + ";\n");
            code.append("\t\tset(\"" + cname + "\",this." + JFinalUtils.toJavaName(cname, null) + ");\n");
            code.append("\t}\n");
            code.append("\n");
            String str = "";
            str = "Integer".equals(ctype) ? "getInt" : ("String".equals(ctype) || "Double".equals(ctype) ? "get" : "get" + ctype);
            code.append("\tpublic " + ctype + " " + JFinalUtils.toJavaName(cname, "get") + "(){\n");
            code.append("\t\tthis." + JFinalUtils.toJavaName(cname, null) + " = " + str + "(\"" + cname + "\");\n");
            code.append("\t\treturn this." + JFinalUtils.toJavaName(cname, null) + ";\n");
            code.append("\t}\n");
            code.append("\n");
        }
        code.append("}");
        JfinalModelGenerator.writeData("D:\\base\\", code.toString(), "Base" + cls, true);
        code = new StringBuffer();
        code.append("package net.roseboy.project.model;\n");
        code.append("\n");
        code.append("import net.roseboy.framework.jfinal.TableBind;\n");
        code.append("import net.roseboy.project.model.base.Base" + cls + ";\n");
        code.append("\n");
        code.append("//" + memo + "\n");
        code.append("@TableBind(tabName=\"" + tb + "\")\n");
        code.append("public class " + cls + " extends Base" + cls + "<" + cls + ">{ \n");
        code.append("\tprivate static final long serialVersionUID = 1L; \n");
        code.append("\tpublic static " + cls + " dao = new " + cls + "();\n");
        code.append("\n\n\n\n");
        code.append("}");
        JfinalModelGenerator.writeData(Path, code.toString(), cls, true);
    }

    private static Map<String, String> getRemData(Connection conn, String tab, String db) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql_col = "SELECT TABLE_SCHEMA,TABLE_NAME,COLUMN_NAME,COLUMN_DEFAULT,IS_NULLABLE,COLUMN_TYPE,COLUMN_KEY,COLUMN_COMMENT from columns where table_name=? AND TABLE_SCHEMA=? ORDER BY ORDINAL_POSITION";
        List<Map<String, Object>> list = KDb.exeQuery(conn, sql_col, tab, db);
        for (Map<String, Object> map2 : list) {
            map.put(map2.get("COLUMN_NAME").toString(), map2.get("COLUMN_COMMENT").toString());
        }
        return map;
    }

    public static void writeData(String path, String message, String className, boolean foce) {
        File fileDir = new File(path);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        try {
            File f = new File(fileDir, className + ".java");
            if (f.exists() && !foce) {
                System.out.println("\"" + f.getAbsolutePath() + "\" Already Exists");
            } else {
                FileOutputStream fos = new FileOutputStream(f);
                OutputStreamWriter osw = new OutputStreamWriter(fos);
                BufferedWriter bw = new BufferedWriter(osw);
                bw.write(message);
                bw.flush();
                bw.getClass();
                osw.close();
                fos.close();
                System.out.println("\"" + f.getAbsolutePath() + "\" WriteSucess");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Connection getConnection() {
        String url = "jdbc:mysql://127.0.0.1:3306/information_schema?user=root&password=root&useUnicode=true&characterEncoding=utf-8";
        Connection conn = null;
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            conn = DriverManager.getConnection(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }
}

