/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.util;

import com.jfinal.log.Log;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassKits {
    public static Log log = Log.getLog(ClassKits.class);
    private static final Map<Class, Object> singletons = new ConcurrentHashMap<Class, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T singleton(Class<T> clazz) {
        Object object = singletons.get(clazz);
        if (object == null) {
            Class<T> clazz2 = clazz;
            synchronized (clazz2) {
                object = singletons.get(clazz);
                if (object == null) {
                    object = ClassKits.newInstance(clazz);
                    if (object != null) {
                        singletons.put(clazz, object);
                    } else {
                        Log.getLog(clazz).error("cannot new newInstance!!!!");
                    }
                }
            }
        }
        return (T)object;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("can not newInstance class:" + clazz + "\n" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstance(String clazzName) {
        try {
            Class<?> clazz = Class.forName(clazzName, false, Thread.currentThread().getContextClassLoader());
            return (T)ClassKits.newInstance(clazz);
        }
        catch (Exception e) {
            log.error("can not newInstance class:" + clazzName + "\n" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static Class<?> getUsefulClass(Class<?> clazz) {
        return clazz.getName().indexOf("$$EnhancerBy") == -1 ? clazz : clazz.getSuperclass();
    }
}

