/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.util;

import com.jfinal.kit.PathKit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import net.roseboy.framework.util.Reflect;

public class ClassSearcher {
    private String classpath = PathKit.getRootClassPath();
    private String libDir = PathKit.getWebRootPath() + File.separator + "WEB-INF" + File.separator + "lib";
    private List<String> scanPackages = new ArrayList<String>();
    private boolean includeAllJarsInLib = false;
    private List<String> includeJars = new ArrayList<String>();
    private Class target;

    private static <T> List<Class<? extends T>> extraction(Class<T> clazz, List<String> classFileList) {
        ArrayList<Class<T>> classList = new ArrayList<Class<T>>();
        for (String classFile : classFileList) {
            Class classInFile = (Class)Reflect.on(classFile).get();
            if (!clazz.isAssignableFrom(classInFile) || clazz == classInFile) continue;
            classList.add(classInFile);
        }
        return classList;
    }

    public static ClassSearcher of(Class target) {
        return new ClassSearcher(target);
    }

    private List<String> findFiles(String baseDirName, String targetFileName) {
        ArrayList<String> classFiles = new ArrayList<String>();
        File baseDir = new File(baseDirName);
        if (baseDir.exists() && baseDir.isDirectory()) {
            String[] files = baseDir.list();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(baseDirName + File.separator + files[i]);
                if (file.isDirectory()) {
                    classFiles.addAll(this.findFiles(baseDirName + File.separator + files[i], targetFileName));
                    continue;
                }
                if (!ClassSearcher.wildcardMatch(targetFileName, file.getName())) continue;
                String fileName = file.getAbsolutePath();
                String open = this.classpath + File.separator;
                String close = ".class";
                int start = fileName.indexOf(open);
                int end = fileName.indexOf(close, start + open.length());
                String className = fileName.substring(start + open.length(), end).replace(File.separator, ".");
                classFiles.add(className);
            }
        }
        return classFiles;
    }

    private static boolean wildcardMatch(String pattern, String fileName) {
        int patternLength = pattern.length();
        int strLength = fileName.length();
        int strIndex = 0;
        for (int patternIndex = 0; patternIndex < patternLength; ++patternIndex) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (ClassSearcher.wildcardMatch(pattern.substring(patternIndex + 1), fileName.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
                continue;
            }
            if (ch == '?') {
                if (++strIndex <= strLength) continue;
                return false;
            }
            if (strIndex >= strLength || ch != fileName.charAt(strIndex)) {
                return false;
            }
            ++strIndex;
        }
        return strIndex == strLength;
    }

    public <T> List<Class<? extends T>> search() {
        List<Object> classFileList = new ArrayList();
        if (this.scanPackages.isEmpty()) {
            classFileList = this.findFiles(this.classpath, "*.class");
        } else {
            for (String scanPackage : this.scanPackages) {
                classFileList = this.findFiles(this.classpath + File.separator + scanPackage.replaceAll("\\.", "\\" + File.separator), "*.class");
            }
        }
        classFileList.addAll(this.findjarFiles(this.libDir));
        return ClassSearcher.extraction(this.target, classFileList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> findjarFiles(String baseDirName) {
        ArrayList<String> classFiles = new ArrayList<String>();
        File baseDir = new File(baseDirName);
        if (baseDir.exists() && baseDir.isDirectory()) {
            File[] files;
            for (File file : files = baseDir.listFiles()) {
                if (file.isDirectory()) {
                    classFiles.addAll(this.findjarFiles(file.getAbsolutePath()));
                    continue;
                }
                if (!this.includeAllJarsInLib && !this.includeJars.contains(file.getName())) continue;
                ZipFile localJarFile = null;
                try {
                    localJarFile = new JarFile(new File(baseDirName + File.separator + file.getName()));
                    Enumeration<JarEntry> entries = ((JarFile)localJarFile).entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        String entryName = jarEntry.getName();
                        if (this.scanPackages.isEmpty()) {
                            if (jarEntry.isDirectory() || !entryName.endsWith(".class")) continue;
                            String className = entryName.replaceAll(File.separator, ".").substring(0, entryName.length() - 6);
                            classFiles.add(className);
                            continue;
                        }
                        for (String scanPackage : this.scanPackages) {
                            scanPackage = scanPackage.replaceAll("\\.", "\\" + File.separator);
                            if (jarEntry.isDirectory() || !entryName.endsWith(".class") || !entryName.startsWith(scanPackage)) continue;
                            String className = entryName.replaceAll(File.separator, ".").substring(0, entryName.length() - 6);
                            classFiles.add(className);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (localJarFile != null) {
                            localJarFile.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return classFiles;
    }

    public ClassSearcher(Class target) {
        this.target = target;
    }

    public ClassSearcher injars(List<String> jars) {
        if (jars != null) {
            this.includeJars.addAll(jars);
        }
        return this;
    }

    public ClassSearcher inJars(String ... jars) {
        if (jars != null) {
            for (String jar : jars) {
                this.includeJars.add(jar);
            }
        }
        return this;
    }

    public ClassSearcher includeAllJarsInLib(boolean includeAllJarsInLib) {
        this.includeAllJarsInLib = includeAllJarsInLib;
        return this;
    }

    public ClassSearcher classpath(String classpath) {
        this.classpath = classpath;
        return this;
    }

    public ClassSearcher libDir(String libDir) {
        this.libDir = libDir;
        return this;
    }

    public ClassSearcher scanPackages(List<String> scanPaths) {
        if (scanPaths != null) {
            this.scanPackages.addAll(scanPaths);
        }
        return this;
    }
}

