/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    public static String parseDate(Date date, String parsePatterns) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(parsePatterns);
            return sdf.format(date);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String parseDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static Date parseDate(String str) throws ParseException {
        return DateUtils.parseDate((String)str, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
    }

    public static Date getFirstDayOfMonth(Date date) throws ParseException {
        String strdate = DateUtils.parseDate(date, "yyyy-MM-01 00:00:00");
        return DateUtils.parseDate(strdate);
    }

    public static int getDayOfWeek() throws ParseException {
        Calendar c = Calendar.getInstance();
        int dayForWeek = 0;
        dayForWeek = c.get(7) == 1 ? 7 : c.get(7) - 1;
        return dayForWeek;
    }

    public static String getWeekOfDate(Date date, int tag) {
        String[] weekDaysName = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        String[] weekDaysCode = new String[]{"7", "1", "2", "3", "4", "5", "6"};
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int intWeek = calendar.get(7) - 1;
        if (tag == 0) {
            return weekDaysName[intWeek];
        }
        return weekDaysCode[intWeek];
    }

    public static Date parseDate(String str, String parsePatterns) throws ParseException {
        return DateUtils.parseDate((String)str, (String[])new String[]{parsePatterns});
    }

    public static String[] getMonths() {
        String[] months = new String[8];
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        months[0] = df.format(cal.getTime()).substring(0, 7);
        for (int i = 1; i <= 7; ++i) {
            cal.add(2, -1);
            months[i] = df.format(cal.getTime()).substring(0, 7);
        }
        return months;
    }

    public static Date getBeginOfDay(Date date) {
        Calendar today = Calendar.getInstance();
        today.setTime(date);
        return DateUtils.truncate((Calendar)today, (int)5).getTime();
    }

    public static Date getEndOfDay(Date date) {
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.setTime(date);
        tomorrow.add(5, 1);
        tomorrow = DateUtils.truncate((Calendar)tomorrow, (int)5);
        tomorrow.add(14, -1);
        return tomorrow.getTime();
    }

    public static Date getBeginOfMonth(Date date) {
        Calendar today = Calendar.getInstance();
        today.setTime(date);
        return DateUtils.truncate((Calendar)today, (int)2).getTime();
    }

    public static Date getEndOfMonth(Date date) {
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.setTime(date);
        tomorrow.add(2, 1);
        tomorrow = DateUtils.truncate((Calendar)tomorrow, (int)2);
        tomorrow.add(13, -1);
        return tomorrow.getTime();
    }

    public static Date getBeginOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.setFirstDayOfWeek(2);
        c.set(7, 2);
        return c.getTime();
    }

    public static Date getEndOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.setFirstDayOfWeek(2);
        c.set(7, 1);
        return c.getTime();
    }

    public static Date getBeginDateOfPeriod(Date beginDate, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(beginDate);
        c.add(5, days);
        return DateUtils.getBeginOfDay(c.getTime());
    }

    public static Date getEndDateOfPeriod(Date endDate, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(endDate);
        c.add(5, days);
        return DateUtils.getEndOfDay(c.getTime());
    }

    public static int getDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static int calcAge(String birthday) {
        int age = 0;
        if (StringUtils.isNotBlank((CharSequence)birthday)) {
            int curYear = Calendar.getInstance().get(1);
            try {
                Calendar temCal = Calendar.getInstance();
                temCal.setTime(DateUtils.parseDate(birthday));
                age = curYear - temCal.get(1);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return age;
    }

    public static Date getBeginOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        return DateUtils.getBeginOfMonth(calendar.getTime());
    }

    public static Date getEndOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        return DateUtils.getEndOfMonth(calendar.getTime());
    }

    public static Date getYesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getEndOfYesterday() {
        return DateUtils.getEndOfDay(DateUtils.getYesterday());
    }

    public static Date getBeginOfYesterday() {
        return DateUtils.getBeginOfDay(DateUtils.getYesterday());
    }

    public static int currentYear() {
        GregorianCalendar c = new GregorianCalendar();
        int year = c.get(1);
        return year;
    }

    public static int currentMonth() {
        GregorianCalendar c = new GregorianCalendar();
        int month = c.get(2);
        return month;
    }

    public static int currentDay() {
        GregorianCalendar c = new GregorianCalendar();
        int day = c.get(5);
        return day;
    }

    public static int currentMinute() {
        GregorianCalendar c = new GregorianCalendar();
        int minute = c.get(12);
        return minute;
    }

    public static int currentHour() {
        GregorianCalendar c = new GregorianCalendar();
        int hour = c.get(10);
        return hour;
    }

    public static int currentSecond() {
        GregorianCalendar c = new GregorianCalendar();
        int second = c.get(13);
        return second;
    }

    public static Date getStartYM(String startYM) {
        try {
            Date date = DateUtils.parseDate(startYM + "-01", "yyyy-MM-dd");
            return DateUtils.getBeginOfMonth(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return DateUtils.getBeginOfMonth(new Date());
        }
    }

    public static Date getEndYM(String endYM) {
        try {
            Date date = DateUtils.parseDate(endYM + "-01", "yyyy-MM-dd");
            return DateUtils.getEndOfMonth(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return DateUtils.getEndOfMonth(new Date());
        }
    }

    public static Long timeStamp() {
        long time = System.currentTimeMillis();
        Long t = time / 1000L;
        return t;
    }

    public static long diff(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return 0L;
        }
        return date2.getTime() - date1.getTime();
    }

    public static void main(String[] args) {
        long s = 1288834974657L;
        System.out.println(DateUtils.parseDate(new Date(s)));
    }
}

