/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.util;

import org.apache.log4j.Logger;

public class Log {
    private static StackTraceElement findCaller() {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        if (null == callStack) {
            return null;
        }
        StackTraceElement caller = null;
        String logClassName = Log.class.getName();
        boolean isEachLogClass = false;
        for (StackTraceElement strackTraceEle : callStack) {
            if (logClassName.equals(strackTraceEle.getClassName())) {
                isEachLogClass = true;
            }
            if (!isEachLogClass || logClassName.equals(strackTraceEle.getClassName())) continue;
            isEachLogClass = false;
            caller = strackTraceEle;
            break;
        }
        return caller;
    }

    private static Logger logger() {
        StackTraceElement caller = Log.findCaller();
        if (caller == null) {
            return Logger.getLogger(Log.class);
        }
        return Logger.getLogger((String)(caller.getClassName() + "." + caller.getMethodName() + "():" + caller.getLineNumber()));
    }

    public static void trace(String msg) {
        Log.trace(msg, null);
    }

    public static void trace(String msg, Throwable e) {
        Log.logger().trace((Object)msg, e);
    }

    public static void debug(String msg) {
        Log.debug(msg, null);
    }

    public static void debug(String msg, Throwable e) {
        Log.logger().debug((Object)msg, e);
    }

    public static void info(String msg) {
        Log.info(msg, null);
    }

    public static void info(String msg, Throwable e) {
        Log.logger().info((Object)msg, e);
    }

    public static void warn(String msg) {
        Log.warn(msg, null);
    }

    public static void warn(String msg, Throwable e) {
        Log.logger().warn((Object)msg, e);
    }

    public static void error(String msg) {
        Log.error(msg, null);
    }

    public static void error(String msg, Throwable e) {
        Log.logger().error((Object)msg, e);
    }
}

