/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtils {
    public static boolean checkEmail(String email) {
        if (email == null) {
            return false;
        }
        String regex = "\\w+@\\w+\\.[a-z]+(\\.[a-z]+)?";
        return Pattern.matches(regex, email);
    }

    public static boolean checkIdCard(String idCard) {
        if (idCard == null) {
            return false;
        }
        String regex = "[1-9]\\d{13,16}[a-zA-Z0-9]{1}";
        return Pattern.matches(regex, idCard);
    }

    public static boolean checkMobile(String mobile) {
        if (mobile == null) {
            return false;
        }
        String regex = "^(13[0-9]|14[579]|15[0-3,5-9]|16[6]|17[0135678]|18[0-9]|19[89])\\\\d{8}$";
        return Pattern.matches(regex, mobile);
    }

    public static boolean checkPhone(String phone) {
        if (phone == null) {
            return false;
        }
        String regex = "(\\+\\d+)?(\\d{3,4}\\-?)?\\d{7,8}$";
        return Pattern.matches(regex, phone);
    }

    public static boolean checkDigit(String digit) {
        if (digit == null) {
            return false;
        }
        String regex = "^\\d{1,}$";
        return Pattern.matches(regex, digit);
    }

    public static boolean checkDecimals(String decimals) {
        if (decimals == null) {
            return false;
        }
        String regex = "\\-?[1-9]\\d+(\\.\\d+)?";
        return Pattern.matches(regex, decimals);
    }

    public static boolean checkBlankSpace(String blankSpace) {
        if (blankSpace == null) {
            return false;
        }
        String regex = "\\s+";
        return Pattern.matches(regex, blankSpace);
    }

    public static boolean checkChinese(String chinese) {
        if (chinese == null) {
            return false;
        }
        String regex = "^[\u4e00-\u9fa5]+$";
        return Pattern.matches(regex, chinese);
    }

    public static boolean checkBirthday(String birthday) {
        if (birthday == null) {
            return false;
        }
        String regex = "[1-9]{4}([-./])\\d{1,2}\\1\\d{1,2}";
        return Pattern.matches(regex, birthday);
    }

    public static boolean checkURL(String url) {
        if (url == null) {
            return false;
        }
        String regex = "(https?://(w{3}\\.)?)?\\w+\\.\\w+(\\.[a-zA-Z]+)*(:\\d{1,5})?(/\\w*)*(\\??(.+=.*)?(&.+=.*)?)?";
        return Pattern.matches(regex, url);
    }

    public static String getDomain(String url) {
        if (url == null) {
            return "";
        }
        Pattern p = Pattern.compile("(?<=http://|\\.)[^.]*?\\.(com|cn|net|org|biz|info|cc|tv)", 2);
        Matcher matcher = p.matcher(url);
        matcher.find();
        return matcher.group();
    }

    public static boolean checkPostcode(String postcode) {
        if (postcode == null) {
            return false;
        }
        String regex = "[1-9]\\d{5}";
        return Pattern.matches(regex, postcode);
    }

    public static boolean checkIpAddress(String ipAddress) {
        if (ipAddress == null) {
            return false;
        }
        String regex = "[1-9](\\d{1,2})?\\.(0|([1-9](\\d{1,2})?))\\.(0|([1-9](\\d{1,2})?))\\.(0|([1-9](\\d{1,2})?))";
        return Pattern.matches(regex, ipAddress);
    }

    public static boolean checkLyuXH(String xh) {
        if (xh == null) {
            return false;
        }
        String regex = "\\d{12}";
        return Pattern.matches(regex, xh);
    }

    public static boolean checkPwd(String pw) {
        if (pw == null) {
            return false;
        }
        return pw.length() >= 6;
    }

    public static void main(String[] args) {
        System.out.println(RegexUtils.checkMobile("17806161362"));
        System.out.println(RegexUtils.checkMobile("18263905008"));
    }
}

