/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.util;

import com.jfinal.kit.LogKit;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.roseboy.framework.util.TestJob;

public class TaskQueue
implements Runnable {
    private static Map<Long, Runnable> taskQueue = new ConcurrentHashMap<Long, Runnable>();

    public static void runAt(Date date, Runnable runjob) {
        TaskQueue.put(date == null ? System.currentTimeMillis() : date.getTime(), runjob);
    }

    public static void runAfter(int millis, Runnable runjob) {
        TaskQueue.put(System.currentTimeMillis() + (long)(millis * 1000), runjob);
    }

    private static void put(long millis, Runnable runjob) {
        while (taskQueue.containsKey(millis)) {
            ++millis;
        }
        LogKit.info((String)("\u4efb\u52a1\u6dfb\u52a0:" + millis + ":" + runjob.toString()));
        taskQueue.put(millis, runjob);
    }

    public static void removeByTag(String tag) {
        if (TaskQueue.count() == 0) {
            return;
        }
        Iterator<Map.Entry<Long, Runnable>> it = taskQueue.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, Runnable> entry = it.next();
            if (!tag.equals(entry.getValue().toString())) continue;
            it.remove();
        }
    }

    public static int count() {
        return taskQueue.size();
    }

    private void runJobs() {
        long currTime = System.currentTimeMillis();
        Iterator<Map.Entry<Long, Runnable>> it = taskQueue.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, Runnable> entry = it.next();
            if (entry.getKey() - currTime > 0L) continue;
            try {
                new Thread(entry.getValue()).start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            it.remove();
        }
    }

    public static void start() {
        new Thread(new TaskQueue()).start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.runJobs();
        }
    }

    public static void main(String[] args) {
        TaskQueue.start();
        TaskQueue.runAfter(10, new TestJob());
    }
}

