/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.io.FileUtils;

public class TxtUtils {
    public static String readTxtFile(String filePath) {
        return TxtUtils.readTxtFile(filePath, "UTF-8");
    }

    public static String readTxtFile(String filePath, String encoding) {
        StringBuffer sb = new StringBuffer("");
        try {
            File file = new File(filePath);
            if (file.isFile() && file.exists()) {
                InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                BufferedReader bufferedReader = new BufferedReader(read);
                String lineTxt = null;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    sb.append(lineTxt);
                }
                read.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static void writeTxtFile(String txt, String filePath) {
        try {
            File writename = new File(filePath);
            writename.createNewFile();
            BufferedWriter out = new BufferedWriter(new FileWriter(writename));
            out.write(txt);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteAllFilesOfDir(File path) {
        if (!path.exists()) {
            return;
        }
        if (path.isFile()) {
            path.delete();
            return;
        }
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            TxtUtils.deleteAllFilesOfDir(files[i]);
        }
        path.delete();
    }

    public static String convertFileSize(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size >= gb) {
            return String.format("%.1f GB", Float.valueOf((float)size / (float)gb));
        }
        if (size >= mb) {
            float f = (float)size / (float)mb;
            return String.format(f > 100.0f ? "%.0f MB" : "%.1f MB", Float.valueOf(f));
        }
        if (size >= kb) {
            float f = (float)size / (float)kb;
            return String.format(f > 100.0f ? "%.0f KB" : "%.1f KB", Float.valueOf(f));
        }
        return String.format("%d B", size);
    }

    public static void copy(String src, String des) {
        TxtUtils.copy(src, des, true);
    }

    public static void copy(String src, String des, boolean override) {
        File file1 = new File(src);
        File[] fs = file1.listFiles();
        File file2 = new File(des);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        for (File f : fs) {
            if (f.isFile()) {
                TxtUtils.fileCopy(f.getPath(), des + "\\" + f.getName(), override);
                continue;
            }
            if (!f.isDirectory()) continue;
            TxtUtils.copy(f.getPath(), des + "\\" + f.getName(), override);
        }
    }

    public static void fileCopy(String src, String des) {
        TxtUtils.fileCopy(src, des, true);
    }

    public static void fileCopy(String src, String des, boolean override) {
        File srcFile = new File(src);
        if (!srcFile.exists()) {
            return;
        }
        File desFile = new File(des);
        if (desFile.exists() && !override) {
            return;
        }
        try {
            FileUtils.copyFile((File)srcFile, (File)desFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

