/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.compression;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.bitbuffer.BitBuf;
import net.rsprot.buffer.bitbuffer.BitBufKt;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.buffer.util.charset.Cp1252Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\t\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J'\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0011\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000eJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001c\u001a\u00020\bH\u0016J\t\u0010\u001d\u001a\u00020\u000eH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001f"}, d2={"Lnet/rsprot/compression/HuffmanCodec;", "", "bits", "", "codewords", "lookupTree", "([I[I[I)V", "maxBitsPerCharacter", "", "component1", "component2", "component3", "copy", "decode", "", "buf", "Lio/netty/buffer/ByteBuf;", "Lnet/rsprot/buffer/JagByteBuf;", "decode-lwEbYT4", "(Lio/netty/buffer/ByteBuf;)Ljava/lang/String;", "encode", "", "text", "encode-14qJkCs", "(Lio/netty/buffer/ByteBuf;Ljava/lang/String;)V", "equals", "", "other", "hashCode", "toString", "Companion", "compression"})
@SourceDebugExtension(value={"SMAP\nHuffmanCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HuffmanCodec.kt\nnet/rsprot/compression/HuffmanCodec\n+ 2 JagByteBuf.kt\nnet/rsprot/buffer/JagByteBuf\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,291:1\n420#2:292\n99#2:293\n424#2,2:294\n11#3,2:296\n*S KotlinDebug\n*F\n+ 1 HuffmanCodec.kt\nnet/rsprot/compression/HuffmanCodec\n*L\n37#1:292\n71#1:293\n93#1:294,2\n131#1:296,2\n*E\n"})
public final class HuffmanCodec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] bits;
    @NotNull
    private final int[] codewords;
    @NotNull
    private final int[] lookupTree;
    private final int maxBitsPerCharacter;
    @NotNull
    private static final Logger logger;
    private static final int MAX_LENGTH = 32768;
    private static final int CODEWORDS_LENGTH = 256;

    public HuffmanCodec(@NotNull int[] bits, @NotNull int[] codewords, @NotNull int[] lookupTree) {
        Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
        Intrinsics.checkNotNullParameter((Object)codewords, (String)"codewords");
        Intrinsics.checkNotNullParameter((Object)lookupTree, (String)"lookupTree");
        this.bits = bits;
        this.codewords = codewords;
        this.lookupTree = lookupTree;
        this.maxBitsPerCharacter = ArraysKt.maxOrThrow((int[])this.bits);
        if (!(this.bits.length == 256)) {
            boolean $i$a$-require-HuffmanCodec$32 = false;
            String $i$a$-require-HuffmanCodec$32 = "Bits array must be 256 elements long";
            throw new IllegalArgumentException($i$a$-require-HuffmanCodec$32.toString());
        }
        if (!(this.codewords.length == 256)) {
            boolean bl = false;
            String string = "Codewords array must be 256 elements long";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String decode(@NotNull ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return this.decode-lwEbYT4(JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)buf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String decode-lwEbYT4(@NotNull ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        boolean bl = false;
        int len = JagexByteBufExtensionsKt.gSmart1or2((ByteBuf)buf);
        byte[] bytes = new byte[len];
        AutoCloseable autoCloseable = (AutoCloseable)BitBufKt.toBitBuf((ByteBuf)buf);
        Object object = null;
        try {
            BitBuf bitBuf = (BitBuf)autoCloseable;
            boolean bl2 = false;
            int node = 0;
            int i = 0;
            while (i < len) {
                node = bitBuf.gBits(1) == 1 ? this.lookupTree[node] : ++node;
                int chr = this.lookupTree[node];
                if ((chr & Integer.MIN_VALUE) == 0) continue;
                bytes[i++] = (byte)(~chr);
                node = 0;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
        }
        boolean bl3 = false;
        if (!(!buf.isReadable())) {
            object = "Check failed.";
            throw new IllegalStateException(object.toString());
        }
        return new String(bytes, (Charset)Cp1252Charset.INSTANCE);
    }

    public final void encode(@NotNull ByteBuf buf, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.encode-14qJkCs(JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)buf), text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void encode-14qJkCs(@NotNull ByteBuf buf, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        byte[] byArray = text.getBytes((Charset)Cp1252Charset.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        if (!(bytes.length < 32768)) {
            boolean $i$a$-require-HuffmanCodec$encode$22 = false;
            String $i$a$-require-HuffmanCodec$encode$22 = "Encoded text length must be strictly less than 32,768 bytes";
            throw new IllegalArgumentException($i$a$-require-HuffmanCodec$encode$22.toString());
        }
        int value$iv = bytes.length;
        boolean bl = false;
        JagexByteBufExtensionsKt.pSmart1or2((ByteBuf)buf, (int)value$iv);
        buf.ensureWritable(this.maxBitsPerCharacter * bytes.length + 8 >>> 3);
        AutoCloseable autoCloseable = (AutoCloseable)BitBufKt.toBitBuf((ByteBuf)buf);
        Throwable throwable = null;
        try {
            BitBuf bitBuf = (BitBuf)autoCloseable;
            boolean bl2 = false;
            for (byte b : bytes) {
                int chr = b & 0xFF;
                int codeword = this.codewords[chr];
                int numBits = this.bits[chr];
                if (!(numBits != 0)) {
                    boolean bl3 = false;
                    String string = "No codeword for data value " + chr;
                    throw new IllegalArgumentException(string.toString());
                }
                bitBuf.pBits(numBits, codeword);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.compression.HuffmanCodec");
        HuffmanCodec cfr_ignored_0 = (HuffmanCodec)other;
        if (!Arrays.equals(this.bits, ((HuffmanCodec)other).bits)) {
            return false;
        }
        if (!Arrays.equals(this.codewords, ((HuffmanCodec)other).codewords)) {
            return false;
        }
        return Arrays.equals(this.lookupTree, ((HuffmanCodec)other).lookupTree);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.bits);
        result = 31 * result + Arrays.hashCode(this.codewords);
        result = 31 * result + Arrays.hashCode(this.lookupTree);
        return result;
    }

    private final int[] component1() {
        return this.bits;
    }

    private final int[] component2() {
        return this.codewords;
    }

    private final int[] component3() {
        return this.lookupTree;
    }

    @NotNull
    public final HuffmanCodec copy(@NotNull int[] bits, @NotNull int[] codewords, @NotNull int[] lookupTree) {
        Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
        Intrinsics.checkNotNullParameter((Object)codewords, (String)"codewords");
        Intrinsics.checkNotNullParameter((Object)lookupTree, (String)"lookupTree");
        return new HuffmanCodec(bits, codewords, lookupTree);
    }

    public static /* synthetic */ HuffmanCodec copy$default(HuffmanCodec huffmanCodec, int[] nArray, int[] nArray2, int[] nArray3, int n, Object object) {
        if ((n & 1) != 0) {
            nArray = huffmanCodec.bits;
        }
        if ((n & 2) != 0) {
            nArray2 = huffmanCodec.codewords;
        }
        if ((n & 4) != 0) {
            nArray3 = huffmanCodec.lookupTree;
        }
        return huffmanCodec.copy(nArray, nArray2, nArray3);
    }

    @NotNull
    public String toString() {
        return "HuffmanCodec(bits=" + Arrays.toString(this.bits) + ", codewords=" + Arrays.toString(this.codewords) + ", lookupTree=" + Arrays.toString(this.lookupTree) + ")";
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\r\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0010"}, d2={"Lnet/rsprot/compression/HuffmanCodec$Companion;", "", "()V", "CODEWORDS_LENGTH", "", "MAX_LENGTH", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "create", "Lnet/rsprot/compression/HuffmanCodec;", "buffer", "Lio/netty/buffer/ByteBuf;", "Lnet/rsprot/buffer/JagByteBuf;", "create-lwEbYT4", "(Lio/netty/buffer/ByteBuf;)Lnet/rsprot/compression/HuffmanCodec;", "compression"})
    @SourceDebugExtension(value={"SMAP\nHuffmanCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HuffmanCodec.kt\nnet/rsprot/compression/HuffmanCodec$Companion\n+ 2 JagByteBuf.kt\nnet/rsprot/buffer/JagByteBuf\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n*L\n1#1,291:1\n113#2:292\n113#2:293\n150#2:294\n56#3,4:295\n*S KotlinDebug\n*F\n+ 1 HuffmanCodec.kt\nnet/rsprot/compression/HuffmanCodec$Companion\n*L\n143#1:292\n145#1:293\n150#1:294\n284#1:295,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HuffmanCodec create(@NotNull ByteBuf buffer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return this.create-lwEbYT4(JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)buffer));
        }

        @NotNull
        public final HuffmanCodec create-lwEbYT4(@NotNull ByteBuf buffer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            boolean bl = false;
            if (buffer.readableBytes() != 256) {
                bl = false;
                throw new IOException("Huffman file should be exactly 256 bytes: " + buffer.readableBytes());
            }
            int[] bits = new int[256];
            int n = bits.length;
            for (int i = 0; i < n; ++i) {
                boolean bl2 = false;
                bits[i] = JagexByteBufExtensionsKt.g1((ByteBuf)buffer);
            }
            int[] nextCodewords = new int[32];
            int nextFreeNode = 0;
            int[] codewords = new int[256];
            int[] lookupTree = null;
            lookupTree = new int[8];
            int n2 = bits.length;
            for (int chr = 0; chr < n2; ++chr) {
                int bit;
                int nextCodeword;
                int i;
                int numBits = bits[chr];
                if (numBits == 0) continue;
                codewords[chr] = nextCodewords[numBits - 1];
                int codeword = codewords[chr];
                for (i = numBits; 0 < i && codeword == (nextCodeword = nextCodewords[i - 1]); --i) {
                    bit = 1 << 32 - i;
                    if ((nextCodeword & bit) == 0) {
                        nextCodewords[i - 1] = nextCodeword | bit;
                        continue;
                    }
                    if (i != 1) {
                        nextCodewords[i - 1] = nextCodewords[i - 2];
                        continue;
                    }
                    nextCodewords[0] = 0;
                }
                for (i = numBits + 1; i < 33; ++i) {
                    if (nextCodewords[i - 1] != codeword) continue;
                    nextCodewords[i - 1] = nextCodewords[numBits - 1];
                }
                int node = 0;
                int i2 = 1;
                if (i2 <= numBits) {
                    while (true) {
                        if ((codeword & (bit = 1 << 32 - i2)) == 0) {
                            ++node;
                        } else {
                            if (lookupTree[node] == 0) {
                                lookupTree[node] = nextFreeNode;
                            }
                            node = lookupTree[node];
                        }
                        if (node >= lookupTree.length) {
                            Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(lookupTree, lookupTree.length * 2), (String)"copyOf(...)");
                        }
                        if (i2 == numBits) break;
                        ++i2;
                    }
                }
                lookupTree[node] = ~chr;
                if (node < nextFreeNode) continue;
                nextFreeNode = node + 1;
            }
            n2 = bits.length;
            for (int i = 0; i < n2; ++i) {
                codewords[i] = codewords[i] >>> 32 - bits[i];
            }
            Logger arg0$iv = logger;
            boolean bl3 = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)arg0$iv)) {
                Logger logger = arg0$iv;
                boolean bl4 = false;
                logger.debug(String.valueOf("Loaded " + codewords.length + " Huffman codewords and " + lookupTree.length + " node lookup tree."));
            }
            return new HuffmanCodec(bits, codewords, lookupTree);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

