/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.crypto.crc;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/rsprot/crypto/crc/CyclicRedundancyCheck;", "", "()V", "CRC32", "", "computeCrc32", "", "buffer", "Lio/netty/buffer/ByteBuf;", "start", "end", "array", "", "crypto"})
public final class CyclicRedundancyCheck {
    @NotNull
    public static final CyclicRedundancyCheck INSTANCE = new CyclicRedundancyCheck();
    @NotNull
    private static final int[] CRC32;

    private CyclicRedundancyCheck() {
    }

    public final int computeCrc32(@NotNull ByteBuf buffer, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int checksum = -1;
        for (int i = start; i < end; ++i) {
            checksum = checksum >>> 8 ^ CRC32[(checksum ^ buffer.getByte(i)) & 0xFF];
        }
        return ~checksum;
    }

    public final int computeCrc32(@NotNull byte[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int checksum = -1;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            checksum = checksum >>> 8 ^ CRC32[(checksum ^ array[i]) & 0xFF];
        }
        return ~checksum;
    }

    /*
     * WARNING - void declaration
     */
    static {
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            void var3_3;
            int n;
            int crc = n = i;
            int n2 = n;
            int[] nArray2 = nArray;
            for (int bit = 0; bit < 8; ++bit) {
                crc = (crc & 1) == 1 ? crc >>> 1 ^ 0xEDB88320 : crc >>> 1;
            }
            nArray2[n2] = var3_3;
        }
        CRC32 = nArray;
    }
}

