<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html lang="en-GB" xml:lang="en-GB" xmlns="http://www.w3.org/1999/xhtml">
<head>
  <title>SPARQL1.1: Test case structure</title>
  <link rel="stylesheet" type="text/css" href="http://www.w3.org/StyleSheets/TR/base.css" />

<style type="text/css">

  pre.diag { background-color: #f0f0f0 ; padding: 0.5em ; border: 1px solid black ; margin-right: 4em ; }
  span.code { font-family: monospace;}
  pre.cvs-id {color: gray}

#tableResult td, th { padding-left:0.5em; padding-right: 0.5em; padding-top:0.2ex ; padding-bottom:0.2ex ;}

/* Tables */
table, td	{ text-align: left; }
table, td, th	{ border-style: solid;
                  border-width: 1px;
                  border-color: black;
                  border-bottom-color: gray;
                  border-right-color: gray; }
table.plain	{ border-spacing: 0px; padding: 0px ; border-collapse: collapse ; }
                  /* cellpadding="0" cellspacing="1" style="border-collapse: collapse" */

p.note {
	border: 2px solid #f00;
	width: 76%;
	margin: 0 7%;
	padding: 1em;
}

  </style>
  <meta name="RCS-Id" content="$Id: README.html,v 1.39 2012-11-21 22:31:23 apollere2 Exp $" />
</head>
<body>
  <div class="head">
    <a href="http://www.w3.org/"><img height="48" width="72" alt="W3C" src="
    http://www.w3.org/Icons/w3c_home" /></a>
<h1 id="main">SPARQL1.1: Test case structure</h1>
  <dl>
      <dd>&nbsp;</dd>
      <dt>Document Editor</dt>
      <dd><a href="http://www.polleres.net/">Axel Polleres</a> &ndash; 
      Siemens AG</dd>
      <dt>Earlier Version Editors</dt>
      <dd><a href="mailto:swh@ecs.soton.ac.uk">Steve Harris</a> &ndash; 
      IAM Research Group, Southampton</dd>
      <dd><a href="mailto:j.broekstra@tue.nl">Jeen Broekstra</a> &ndash; 
		Information Systems Group, Eindhoven University of Technology</dd>
       <dd><a href="mailto:lee@thefigtrees.net">Lee Feigenbaum</a> &ndash;
        Cambridge Semantics</dd>
      <dt>Version:</dt>
      <dd><code>$Revision: 1.39 $</code></dd>
  </dl>

    <p class="copyright"><a href="
    http://www.w3.org/Consortium/Legal/ipr-notice#Copyright">Copyright</a> &copy;
    2010 <a href="http://www.w3.org/"><acronym title="
    World Wide Web Consortium">W3C</acronym></a><sup>&reg;</sup> ( <a href="
    http://www.csail.mit.edu/"><acronym title="
    Massachusetts Institute of Technology">MIT</acronym></a>, <a href="
    http://www.ercim.org/"><acronym title="
    European Research Consortium for Informatics and Mathematics">ERCIM</acronym></a>,
    <a href="http://www.keio.ac.jp/">Keio</a>), All Rights Reserved. W3C
    <a href="
    http://www.w3.org/Consortium/Legal/ipr-notice#Legal_Disclaimer">liability</a>,
    <a href="
    http://www.w3.org/Consortium/Legal/ipr-notice#W3C_Trademarks">trademark</a>,
    and <a href="
    http://www.w3.org/Consortium/Legal/copyright-documents">document use</a>

    rules apply.</p></div>

<hr title="Separator for header" />
<div>
<h2 id="abstract">Abstract</h2>
<p>This document describes the testing process used by the
<a href="http://www.w3.org/2009/sparql/wiki/">SPARQL Working Group</a>.</p>
</div>
<div>
    <h2><a name="status" id="status">Status of This Document</a></h2>
    <p>Working Document.</p>
</div>
  <hr />
<div>
    <h2><a name="toc" id="toc">Table of Contents</a></h2>
    <p>
   <a href="#organization"/>Organization</a><br/>
   <a href="#vocabularies"/>Manifest Vocabularies</a><br/>
   <a href="#structure"/>Manifest Structure</a><br/>
   <a href="#filenames"/>File Names</a><br/>
   <a href="#syntaxtests"/>Syntax Tests</a><br/>
   <a href="#queryevaltests"/>Query Evaluation Tests</a><br/>
   <a href="#csvtests"/>CSV Result Format Tests</a><br/>
   <a href="#entailevaltests"/>Entailment Evaluation Tests</a><br/>
   <a href="#updateevaltests"/>Update Evaluation Tests</a><br/>
   <a href="#servicetests"/>Federated Query Tests</a><br/>
   <a href="#protocoltests"/>Protocol Tests</a><br/>
   <a href="#servicedescriptiontests"/>Service Description Tests</a><br/>
   <a href="#graphstoreprotocoltests"/>Graph Store HTTP Protocol Tests</a><br/>
   <a href="#testannotations"/>Test annotations</a><br/>
   <a href="#howto"/>How to run the Test Cases</a><br/>
  </p>
</div>
  <hr />


<p>The <a href="http://www.w3.org/2009/sparql/wiki/">SPARQL Working Group</a> uses a test-driven process.&nbsp; The <a href=".">test area</a> is a collection of the current test cases of the working group extending and updating the <a href="http://www.w3.org/2001/sw/DataAccess/tests/r2">testcases</a> of the <a href="http://www.w3.org/2001/sw/DataAccess/">Data Access Working Group</a>. </p>
<p>Tests are divided into collections (corresponding to directories) for manageability.&nbsp; Each collection of tests has a <em>manifest file</em> within its directory (named <tt>manifest.ttl</tt>, but also <tt>manifest.jsonld</tt>, and <tt>index.html</tt> with RDF represented using RDFa). There are also a number of overall manifests containing entries pointing to the individual test collection manifests:</p>
<ul>
  <li><a href="data-r2/index-syntax.html">manifest of syntax-only tests</a> (positive and negative tests) for the <a href="http://www.w3.org/TR/rdf-sparql-query/">SPARQL 1.0 Query Language</a></li>
  <li><a href="data-r2/index-evaluation.html">manifest of query-evaluation tests</a> for the <a href="http://www.w3.org/TR/rdf-sparql-query/">SPARQL 1.0 Query Language</a>.</li>

  <li><a href="data-sparql11/index-sparql11-query.html">manifest of syntax and evaluation tests</a> (positive and negative tests) for the <a href="http://www.w3.org/TR/sparql11-query/">SPARQL 1.1 Query Language</a></li>
  <li><a href="data-sparql11/index-sparql11-update.html">manifest of syntax and evaluation tests</a> (positive and negative tests) for the <a href="http://www.w3.org/TR/sparql11-update/">SPARQL 1.1 Update Language</a></li>
  <li><a href="data-sparql11/csv-tsv-res/index.html">manifest of CSV and TSV format tests</a> for the <a href="ttp://www.w3.org/TR/sparql11-results-csv-tsv/">SPARQL 1.1 Query Results CSV and TSV Formats</a></li>
  <li><a href="data-sparql11/json-res/index.html">manifest of JSON format tests</a> for the <a href="http://www.w3.org/TR/sparql11-results-json/">SPARQL 1.1 Query Results JSON Format</a></li>
  <li><a href="data-sparql11/index-sparql11-fed.html">manifest of syntax and evaluation tests</a> (positive and negative tests) for the <a href="http://www.w3.org/TR/sparql11-federated-query/">SPARQL 1.1 Federation Extensions</a></li>
  <li><a href="data-sparql11/entailment/index.html">manifest of entailment evaluation tests</a> for the <a href="http://www.w3.org/TR/sparql11-entailment/">SPARQL 1.1 Entailment Regimes</a></li>
  <li><a href="data-sparql11/service-description/index.html">manifest of service description tests</a> for the <a href="http://www.w3.org/TR/sparql11-service-description/">SPARQL 1.1 Service Description</a></li>
  <li><a href="data-sparql11/protocol/index.html">manifest of protocol tests</a> for the <a href="http://www.w3.org/TR/sparql11-protocol/">SPARQL 1.1 Protocol</a></li>
  <li><a href="data-sparql11/http-rdf-update/index.html">manifest of graph protocol tests</a> for the <a href="http://www.w3.org/TR/sparql11-http-rdf-update/">SPARQL 1.1 Graph Store HTTP Protocol</a></li>

</ul>

<h4><a name="organization" id="organization"/>Organization</a></h4>
<p>
The test cases are organised in two directories</p>
<ul>
  <li>The <a href="data-r2/">data-r2</a> directory holds the testcases from the previous <a href="http://www.w3.org/2001/sw/DataAccess/tests/r2">testcases</a> SPARQL1.0 Query language test suite @@@plus new tests that are restricted to SPARQL 1.0 features only??? @@@.</li>
  <li>The <a href="data-sparql11">data-sparql11</a> directory holds test cases aimed at covering as much of the SPARQL 1.1 Query Language and SPARQL 1.1 Update Language as possible.</li>
</ul>
  The purpose is to provide an up-to-date, upwards-compatible, consistent, and easy-to-use suite of test cases that SPARQL 1.1 implementors can use to evaluate and report on their
implementation.
</p>
<p>
The tests as-is shall constitute a test suite that the group will
use to generate an implementation report for the SPARQL1.1 Query  and SPARQL1.1 Update languages.</p>
</p>
  <h4><a name="vocabularies" id="vocabularies"/>Manifest Vocabularies</a></h4>

  <p>The SPARQL1.1 test manifest files define five vocabularies to express
  tests and results:</p>

  <ol>
    <li><a href="http://www.w3.org/2001/sw/DataAccess/tests/test-manifest.n3">manifest vocabulary</a> (prefixed with
    <tt>mf:</tt> below)</li>
    <li><a href="http://www.w3.org/2001/sw/DataAccess/tests/test-query.n3">query evaluation test vocabulary</a> (prefixed
    with <tt>qt:</tt> below)</li>
    <li><a href="test-update.n3">update evaluation test vocabulary</a> (prefixed
    with <tt>ut:</tt> below)</li>
    <li><a href="http://www.w3.org/2001/sw/DataAccess/tests/test-dawg.n3">DAWG test approval vocabulary</a> (prefixed
    with <tt>dawgt:</tt> below)</li>
    <li><a href="http://www.w3.org/2001/sw/DataAccess/tests/test-dawg.n3">DAWG result-set RDF vocabulary</a> (prefixed
    with <tt>rs:</tt> below)</li>
  </ol>
  
  <p>All examples below use these prefix bindings (specified in <a
  href="http://www.w3.org/2001/sw/DataAccess/df1/">turtle</a>):</p>

  <pre class="diag">@prefix rdf:     &lt;http://www.w3.org/1999/02/22-rdf-syntax-ns#&gt; .
@prefix rdfs:    &lt;http://www.w3.org/2000/01/rdf-schema#&gt; .
@prefix mf:      &lt;http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#&gt; .
@prefix dawgt:   &lt;http://www.w3.org/2001/sw/DataAccess/tests/test-dawg#&gt; .
@prefix qt:      &lt;http://www.w3.org/2001/sw/DataAccess/tests/test-query#&gt; .
@prefix ut:      &lt;http://www.w3.org/2009/sparql/tests/test-update#&gt; .
@prefix sd:      &lt;http://www.w3.org/ns/sparql-service-description#&gt; .
@prefix ent:     &lt;http://www.w3.org/ns/entailment/RDF&gt; .
@prefix rs:      &lt;http://www.w3.org/2001/sw/DataAccess/tests/result-set#&gt; .  
  </pre>

  <h4><a name="structure" id="structure"/>Manifest Structure</a></h4>

  <p>
A manifest is a list (RDF Collection) of tests. Every test has 
a name (<tt>mf:name</tt>); many tests also have a comment
(<tt>rdfs:comment</tt>) explaining the purpose of the test.
The <tt>dawgt:approval</tt> predicate relates a test to its official
Working Group status (e.g. <tt>dawgt:Approved</tt>).
Tests are grouped (via their <tt>rdf:type</tt>) as:
</p>

<ul>
	<li>positive SPARQL 1.0 Query syntax tests (<tt>mf:PositiveSyntaxTest</tt>)</li>
	<li>positive SPARQL 1.1 Query syntax tests (<tt>mf:PositiveSyntaxTest11</tt>)</li>
	<li>positive SPARQL 1.1 Update syntax tests (<tt>mf:PositiveUpdateSyntaxTest11</tt>)</li>
	<li>negative SPARQL 1.0 Query syntax tests (<tt>mf:NegativeSyntaxTest</tt>)</li>
	<li>negative SPARQL 1.1 Query syntax tests (<tt>mf:NegativeSyntaxTest11</tt>)</li>
	<li>negative SPARQL 1.1 Update syntax tests (<tt>mf:NegativeUpdateSyntaxTest11</tt>)</li>
	<li>SPARQL 1.0 and 1.1 Query evaluation tests (<tt>mf:QueryEvaluationTest</tt>)</li>
	<li>SPARQL 1.1 Update evaluation tests (<tt>mf:UpdateEvaluationTest</tt>)</li>
	<li>CSV Result Format tests (<tt>mf:CSVResultFormatTest</tt>)</li>
	<li>SPARQL 1.1 Service Description tests (<tt>mf:ServiceDescriptionTest</tt>)</li>
</ul>

  <h4><a name="filenames" id="filenames"/>File Names</a></h4>
  
 <p>Typically, in the test case suite, we use the following suffixes to indicate different file types:</p>
 <ul>
    <li><b>.ttl</b> ... Files describing RDF graphs in <a href="http://www.w3.org/TeamSubmission/turtle/">Turtle</a> syntax.
    </li>
    <li><b>.rdf</b> ... Files describing RDF graphs in <a href="http://www.w3.org/TR/rdf-syntax-grammar/">RDF/XML</a> syntax.
    </li>
    <li><b>.rq</b> ... Files containing a <a href="http://www.w3.org/TR/sparql11-query/">SPARQL1.1 Query</a> request.
    </li>
    <li><b>.ru</b> ... Files containing a <a href="http://www.w3.org/TR/sparql11-update/">SPARQL1.1 Update</a> request.
    </li>
    <li><b>.srx</b> ... Files containing a query result in the <a href="http://www.w3.org/TR/rdf-sparql-XMLres/">SPARQL Query Results XML Format</a>.
    </li>
    <li><b>.srj</b> ... Files containing a query result in the <a href="http://www.w3.org/TR/sparql11-results-json/">SPARQL 1.1 Query Results JSON Format</a>.
    </li>
    <li><b>.csv</b> ... Files containing a query result in the <a href="http://www.w3.org/TR/sparql11-results-csv-tsv/">SPARQL 1.1 Query Results CSV (Comma Separated Values) Format</a>.
    </li>
    <li><b>.tsv</b> ... Files containing a query result in the <a href="http://www.w3.org/TR/sparql11-results-csv-tsv/">SPARQL 1.1 Query Results TSV (Tab Separated Values) Format</a>.
    </li>
  </ul>
<p>@@@ Fix/check final URL for http://www.w3.org/TR/sparql11-results-json/!</p>

 <p>@@@ Will we update the SPARQL Query Results XML Format spec for SPARQL1.1?</p>

  <h4><a name="syntaxtests" id="syntaxtests"/>Syntax Tests</a></h4>

  <p>
Each syntax test has an <tt>mf:action</tt>, the object of which is a
resource identifying a (possible) query string. An example definition of a
syntax test is:
  </p>

<pre class="diag">
&lt;#syntax-basic-01&gt;  mf:name  "syntax-basic-01.rq" ;
     rdf:type   mf:PositiveSyntaxTest ;
     mf:action  &lt;syntax-basic-01.rq&gt; ;
     dawgt:approvedBy &lt;http://lists.w3.org/Archives/Public/public-rdf-dawg/2007JanMar/0047&gt; ;
     dawgt:approval dawgt:Approved .
</pre>

<p>
A SPARQL implementation passes a <tt>mf:PositiveSyntaxTest</tt> if it parses
the query string without error. A SPARQL implementation passes a
<tt>mf:NegativeSyntaxTest</tt> if it raises an error while attempting to parse
the query string.
</p>

  <h4><a name="queryevaltests" id="queryevaltests"/>Query Evaluation Tests</a></h4>

  <p>Each query evaluation test has an <tt>mf:action</tt> and an
  <tt>mf:result</tt>. The object of <tt>mf:action</tt> is a resource with
  properties taken from the query evaluation test vocabulary. At a minimum, a
  test's action includes  a <tt>qt:query</tt>
  relation and an optional <tt>qt:data</tt> relation. The <tt>qt:data</tt>
  predicate points to a URI that can be dereferenced to yield the
  default graph for the test. The <tt>qt:query</tt> prediate points to a
  URI that can be dereferenced to yield the query string for the test. Query evaluation tests may also use the <tt>qt:graphData</tt> predicate to indicate the named graph components of the test's RDF dataset.</p>

  <p>In case the query in the <tt>qt:query</tt> predicate contains  <tt>FROM</tt> and <tt>FROM NAMED</tt> clauses and no <tt>qt:data</tt> is present, the graphs comprising the test's RDF dataset are expected to be loaded by dereferencing the respective URIs of the <tt>FROM/FROM NAMED</tt> clauses.</p>

  <p>Query evaluation tests also contain an <tt>mf:result</tt> which points to
  a URI that can be dereferenced to yield the
  expected results of the test query. These results are expressed in one of
  several possible ways:</p>

  <ul>
    <li>The <a href="http://www.w3.org/TR/rdf-sparql-XMLres/">SPARQL Query
    Results XML Format</a>. SELECT or ASK queries.</li>
    <li>The <a href="http://www.w3.org/TR/sparql11-results-json/">SPARQL Query
    Results JSON Format</a>. SELECT or ASK queries.</li>
    <li>The <a href="http://www.w3.org/TR/sparql11-results-csv-tsv/#tsv">SPARQL Query
    Results TSV Format</a>. SELECT or ASK queries. (As for testing the <a href="http://www.w3.org/TR/sparql11-results-csv-tsv/#csv">SPARQL Query
    Results CSV Format</a>, see the separate Section within this document on <a href="#csvtests">CSV Result Format Tests</a>).</li>
    <li>The <a href="http://www.w3.org/2001/sw/DataAccess/tests/result-set.n3">DAWG result-set RDF vocabulary</a>.
    SELECT or ASK queries.</li>
    <li><a href="http://www.w3.org/TR/rdf-syntax-grammar/">RDF/XML</a> or <a
    href="http://www.dajobe.org/2004/01/turtle/">Turtle</a>. CONSTRUCT queries.</li>
  </ul>

<p>A SPARQL implementation passes a query evaluation test if the graph
produced by evaluating the query against the RDF dataset (and encoding in the
DAWG result set vocabulary, if necessary) is 
<a href="http://www.w3.org/TR/rdf-concepts/#section-graph-equality">equivalent</a> [RDF-CONCEPTS] 
to the graph named in the result (after encoding in the DAWG result set
vocabulary, if necessary).  Note that, solution order only is considered relevant, if the result is expressed in the test suite in the DAWG result set vocabulary, with explicit <code>rs:index</code> triples; otherwise solution order is considered irrelevant for passing. Equivalence can be tested by 
checking that the graphs are isomorphic and have identical IRI and 
literal nodes. Note that testing whether two result sets are isomorphic is simpler than full graph isomorphism. Iterating over rows in one set, finding a match with the other set, removing this pair, then making sure all rows are accounted for, achieves the same effect. </p>

<p>Query evaluation tests that involve the <a href="http://www.w3.org/TR/rdf-sparql-query#modReduced">REDUCED</a> keyword have slightly different passing criteria. These tests are indicated in the manifest files with the <tt>mf:resultCardinality</tt> predicate with an object of <tt>mf:LaxCardinality</tt>. To pass such a test, the result set produced by a SPARQL implementation must contain each solution in the expected result set at least once and no more than the number of times that the solution occurs in the expected result set. (That is, the expected result set contains the solutions with cardinalities as they would be if the query did not contain REDUCED; to pass the test, an implementation must produce the correct results with cardinalities between one and the cardinlity in the expected result set.)</p>

<p>An example definition of a query evaluation test is:</p>

<pre class="diag">
&lt;#dawg-regex-002&gt; a mf:QueryEvaluationTest ;
      mf:name    "regex-query-002" ;
      dawgt:approval dawgt:Approved ;
      dawgt:approvedBy &lt;http://lists.w3.org/Archives/Public/public-rdf-dawg/2007AprJun/0029.html&gt; ;
      rdfs:comment
          "Case insensitive unanchored match test" ;
      mf:action
          [ qt:query  &lt;regex-query-002.rq&gt; ;
            qt:data   &lt;regex-data-01.n3&gt; ] ;
      mf:result  &lt;regex-result-002.n3&gt; .
</pre>

  <h4><a name="csvtests" id="csvtests"/>CSV Result Format Tests</a></h4>

  <p>
CSV Result Format tests are meant to test a SPARQL implementation's ability to serialize query results in the SPARQL 1.1 Query Results CSV Format.
This is a lossy format, however, and so cannot be tested in the same manner as the other result formats.
Care should be taken to ensure that results produced in the CSV format are compared properly to the expected result values.
In all other respects, CSV tests should be treated as <a href="#queryevaltests">query evaluation tests</a>.
  </p>

<p>An example result set in the CSV Format is:</p>
<pre class="diag">
s,p,o
http://example.org/s2,http://example.org/p2,2.2
</pre>

<p>Due to the lossy nature of the CSV format, the single expected result could match any of the following actual results:</p>

<ul>
	<table class="plain">
	<tr>
		<th>s</th>
		<th>p</th>
		<th>o</th>
	</tr>
	<tr>
		<td>&lt;http://example.org/s2&gt;</td>
		<td>&lt;http://example.org/p2&gt;</td>
		<td>"2.2"</td>
	</tr>
	<tr>
		<td>&lt;http://example.org/s2&gt;</td>
		<td>&lt;http://example.org/p2&gt;</td>
		<td>"2.2"^^xsd:string</td>
	</tr>
	<tr>
		<td>&lt;http://example.org/s2&gt;</td>
		<td>&lt;http://example.org/p2&gt;</td>
		<td>"2.2"^^xsd:decimal</td>
	</tr>
	</table>
</ul>




  <h4><a name="entailevaltests" id="entailevaltests"/>Entailment Evaluation Tests</a></h4>

<p>Entailment Evaluation tests are special query evaluation tests that additionally (slightly ab-)use the <tt>sd:entailmentRegime</tt> and, optionally, the <tt>sd:EntailmentProfile</tt> properties from the <a href="http://www.w3.org/TR/sparql11-service-description/">SPARQL 1.1 Service Description<a> vocabulary to further specify the  object of the <tt>mf:action</tt> property, indicating the expected entailment regime for graphs in the dataset and, where applicable, which OWL profile that test satisfies.</p>

<p>A SPARQL implementation passes a query evaluation test if its
answers over any graphs in the dataset using the <tt>sd:entailmentRegime</tt>
property comply with the criteria formalised in the
<a href="http://www.w3.org/TR/sparql11-entailment/">SPARQL 1.1 Entailment Regimes<a> document. Apart from that, passing tests is as defined for query evaluation tests.</p>

<p>An example definition of an entailment evaluation test for the RDF entailment regime is:</p>

<pre class="diag">
:rdf01 rdf:type mf:QueryEvaluationTest ;
    mf:name    "RDF inference test" ;
    dawgt:approval dawgt:NotClassified ;
    mf:action
         [ qt:query  &lt;rdf01.rq&gt; ;
           qt:data   &lt;rdf01.ttl&gt; 
           sd:entailmentRegime ent:RDF ] ;
    mf:result  &lt;rdf01.srx&gt;
    .
 </pre>

<p>Instead of a single entailment regime, tests can also be marked with a list of regimes. In this case, 
any of the entailment regimes can be used to run the test. Similarly, the supported OWL profiles can be given as a 
list or as a single value:</p>

<pre class="diag">
    :sparqldl-10  rdf:type   mf:QueryEvaluationTest ;
         mf:name  "sparqldl-10.rq: undist vars test" ;
         mf:action
                [ qt:query  <sparqldl-10.rq> ;
                qt:data <data-07.ttl> ;
           sd:EntailmentProfile ( pr:DL pr:EL pr:Full ) ;
           sd:entailmentRegime ( ent:OWL-Direct ent:OWL-RDF-Based )  ] ;
         mf:result  <sparqldl-10.srx> .
</pre>

<p>Note that, strictly speaking, this use of the <tt>sd:entailmentRegime</tt></a> property - by its specified <a href="http://www.w3.org/TR/sparql11-service-description/#sd-entailmentRegime">domain</a> - makes the object of the <tt>mf:action</tt> attribute a member of the <tt>sd:NamedGraph</tt> class; the <tt>sd:NamedGraph</tt> class though has no meaning within the context of test cases, so this domain specification can be savely ignored.</p>


  <h4><a name="updateevaltests" id="updateevaltests"/>Update Evaluation Tests</a></h4>

  <p>Each update evaluation test has an <tt>mf:action</tt> and an
  <tt>mf:result</tt>. The object of <tt>mf:action</tt> for an Update evaluation test case is a resource with properties taken from the update evaluation test vocabularies.
  The latter is used among others to describe the graph store's state before and after the execution of an update.  At a minimum, a test's action includes a <tt>ut:request</tt> relation.</p>

<p>The optional <tt>ut:data</tt> and <tt>ut:graphData</tt> relations within the <tt>mf:action</tt> of an update test case point the status of the <a href="http://www.w3.org/TR/sparql11-update/#sec_graphStore">Graph Store</a> <i>prior</i> to the update execution described in terms of at most one <tt>ut:data</tt> property denoting the unnamed graph and optional <tt>ut:graphData</tt> properties denoting named graphs. 
 The object of the <tt>ut:data</tt> property is a URI reference to an RDF graph, whereas the objects of the <tt>ut:graphData</tt> property indicate the named graph components of the Graph Store. Named graphs are described either - analogous to the <tt>qt:graphData</tt> property from the query test vocabulary - by explicit URI reference (in which case the graph name is supposed to correspong to the respective URI reference), or the object of the <tt>ut:graphData</tt> property may be a resource further described in terms of an <tt>ut:graph</tt> and an <tt>rdfs:label</tt> property. Here, the <tt>ut:graph</tt> property is a URI reference to an RDF graph, whereas the <tt>rdfs:label</tt> property with plain literal value indicates the graph's name under which it is accessible in the graph store. The ability to assign a "name" different from the URI reference name explicitly to a named graph in a graph store is needed to denote different graphs by the same name to describe the status of a named graph prior and after execution of an update.</p> 

<p>In the case of absence of both <tt>ut:data</tt> and <tt>ut:graphData</tt> properties within the <tt>mf:action</tt>, the graph store is supposed to be empty (i.e., with an empty default graph and no named graphs) prior to execution of the update. 
</p>

<p>
The
  <tt>ut:request</tt> predicate points to a URI that can be dereferenced to yield
  the update query string for the test.</p>

  <p>Update evaluation tests also contain an <tt>mf:result</tt>. The object of <tt>mf:result</tt> is a resource described in terms of the <tt>ut:data</tt> and <tt>ut:graphData</tt> properties. The optional <tt>ut:data</tt> and <tt>ut:graphData</tt> properties within a an update evaluation test result denote the state of the graphstore <i>after</i> execution of the query analogous to the  <tt>ut:data</tt> and <tt>ut:graphData</tt> properties occurring in the <tt>mf:action</tt> of an update evaluation test.
In the case of absence of both <tt>ut:data</tt> and <tt>ut:graphData</tt> properties within the <tt>mf:result</tt>, the graph store is supposed to be empty after execution of the update. 
</p>

<p>A SPARQL implementation passes a update evaluation test if the graphs in the graph store are 
<a href="http://www.w3.org/TR/rdf-concepts/#section-graph-equality">equivalent</a> [RDF-CONCEPTS] 
to the graphs denoted in the <tt>mf:action</tt> (and <tt>mf:result</tt>) property, respectively) prior to the update execution (after update execution, respectively). Equivalence can be tested as described above for query evaluation tests.</p>

<p>An example definition of an update evaluation test is:</p>

<pre class="diag">
:insert-data-spo1 a mf:UpdateEvaluationTest ;
    mf:name    "Simple insert data 1" ;
    rdfs:comment "This is a simple insert of a single triple to the unnamed graph of an empty graph store" ;
    dawgt:approval dawgt:NotClassified ;
    mf:action [
                ut:request &lt;insert-data-spo1.ru&gt; ; 
                ut:data &lt;empty.ttl&gt; 
              ] ;
    mf:result [  
                ut:data  &lt;spo.ttl&gt;
              ] .
</pre>

<h4><a name="servicetests" id="servicetests"/>Federated Query Tests</a></h4>

<p>In SPARQL 1.1 Federated Query, tests cases contain new vocabulary not used before. These tests check whether the queries with that operator are correct or not. Queries using the <code>SERVICE</code> keyword for accessing remote SPARQL endpoints need a way to describe the data comming from these endpoints which was not previously defined.</p>

<p>The predicate <code>qt:serviceData</code> helps to describe the data comming from these remote SPARQL endpoints in a query. This predicate can also contain the predicate <code>qt:endpoint</code> which contains the URL of the remote SPARQL endpoint.</p>

<p>An example definition of a Federated Query test is:</p>

<pre class="diag">
:service1 rdf:type mf:QueryEvaluationTest ;
       mf:name    "SERVICE test 1" ;
       dawgt:approval dawgt:NotClassified ;
       mf:feature sd:BasicFederatedQuery ;
       mf:action [
               qt:query  &lt;service01.rq&gt; ;
               qt:data   &lt;data01.ttl&gt; ;
               qt:serviceData [
                       qt:endpoint &lt;http://example.org/sparql&gt; ;
                       qt:data     &lt;data01endpoint.ttl&gt;
               ]
       ] ;
       mf:result  &lt;service01.srx&gt; .</pre>



<h4><a name="protocoltests" id="protocoltests"/>Protocol Tests</a></h4>

<p>A testing service for <a href="http://www.w3.org/TR/sparql11-protocol/">SPARQL 1.1 Protocol</a> implementations has been set up at <tt><a href="http://www.w3.org/2009/sparql/protocol_validator">http://www.w3.org/2009/sparql/protocol_validator</a></tt>. The service and tests performed by this service are described in a <a href="https://github.com/kasei/sparql11-protocolvalidator">separate document</a>.</p>

<h4><a name="servicedescriptiontests" id="servicedescriptiontests"/>Service Description Tests</a></h4>

<p>A testing service for SPARQL 1.1 Protocol implementations supporting <a href="http://www.w3.org/TR/sparql11-service-description/">SPARQL 1.1 Service Descriptions</a> has been set up at <tt><a href="http://www.w3.org/2009/sparql/sdvalidator">http://www.w3.org/2009/sparql/sdvalidator</a></tt>. The service performs a number of tests to verify that a submitted endpoint returns RDF that conforms to the service description vocabulary specification. Using content negotiation to request RDF (supporting both Turtle and RDF/XML), the service can be used to generate an <a href="http://www.w3.org/2001/sw/DataAccess/tests/earl">EARL implementation report</a>.</p>

<h4><a name="graphstoreprotocoltests" id="graphstoreprotocoltests"/>Graph Store HTTP Protocol Tests</a></h4>

<p>A number of test cases for the <a href="http://www.w3.org/TR/sparql11-http-rdf-update/">SPARQL 1.1 Graph Store HTTP Protocol</a> consisting of HTTP requests and expected responses are described in a <a href="data-sparql11/http-rdf-update/index.html">separate document</a>.</p> 

  <h4><a name="testannotations" id="testannotations"/>Test annotations</a></h4>

<p>@@@ This section might need reconsideration to reflect extensions (like new library functions) that have become standard in SPARQL1.1 @@@</p>
  <h5>mf:requires</h5>
  <p>A number of tests in the open-world directory illustrate features of SPARQL 
  by depending on how a SPARQL query processor can extend the set of core types 
  and operations as defined by the operator table [<a href="http://www.w3.org/TR/rdf-sparql-query/">http://www.w3.org/TR/rdf-sparql-query/#OperatorMapping</a>].</p>
  <p>These tests are marked by property <code>mf:requires</code> and an object value from one 
  of the URIs described below.</p>
  <dl>
    <dt><code>mf:XsdDateOperations</code></dt>
    <dd>Requires the processor to understand comparisons of 
    literal of type xsd:date. Without providing operations on the xsd:date datatype, a 
    processor would raise an error&nbsp;on the operations of &quot;=&quot; and &quot;!=&quot; 
    etc. With 
    an understanding of xsd:date, a processor can perform value-based operations 
    and provide the operations described in &quot;XQuery 1.0 and XPath 2.0 Functions 
    and Operators&quot; (e.g. <a href="http://www.w3.org/TR/xpath-functions/">
    date-equals</a> <a href="http://www.w3.org/TR/xpath-functions/">
    date-less-than</a>)</dd>

	<dt><code>mf:StringSimpleLiteralCmp</code></dt>
    <dd>This indicates that the test uses the fact that plain literals, without 
    language tags test are the same value as an <code>xsd:string</code> with the same 
    lexicial form. This is covered by rules &quot;xsd 1a&quot; and &quot;xsd 1b&quot; from RDF 
    Semantics [<a href="http://www.w3.org/TR/rdf-mt/">http://www.w3.org/TR/rdf-mt/#DtypeRules</a>].</dd>
    
    <dt><code>mf:KnownTypesDefault2Neq</code></dt>
    <dd>This indicates that a processor extends the SPARQL operator model by 
    using the fact that values of literals can be in disjoint value spaces and 
    hence can not be equal by value. For example, an xsd:integer can not be the 
    same value as an xsd:boolean because these two datatypes define disjoint 
    value spaces.</dd>

<dt><code>mf:LangTagAwareness</code></dt>
	<dd>This indicates that the test assumes the SPARQL query processor has support 
for plain literals with language tags.  The minimum set of operators in the 
    <a href="http://www.w3.org/TR/rdf-sparql-query/#OperatorMapping">SPARQL operator table</a> 
does not include language tag handling, only plain literals without language 
tag (simple literals) and certain XSD datatypes.

</dl>

    <h5>mf:notable</h5>
  <p>This annotation indicates a feature of SPARQL that implementers might note:</p>
  <dl>
    <dt><code>mf:IllFormedLiteral</code></dt>
    <dd>The test involves handling of ill-formed literals.</dd>

</dl>

  <h4><a name="howto" id="howto"/>How to run the Test Cases</a></h4>


<p><b>@@@ This section shall contain some hints on how to actually run the test suite and generate implementation reports for implementers.</b></p>

    <p>&nbsp;</p>



</body>
</html>
