/*
 * Decompiled with CFR 0.152.
 */
package net.sc8s.akka.stream;

import akka.stream.ActorAttributes$;
import akka.stream.Graph;
import akka.stream.Supervision$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import izumi.fundamentals.platform.language.CodePosition;
import izumi.logstage.api.IzLogger;
import izumi.logstage.api.Log;
import izumi.logstage.api.rendering.LogstageCodec$;
import java.io.Serializable;
import net.sc8s.akka.stream.RateLogger;
import net.sc8s.akka.stream.RateLogger$Stats$;
import net.sc8s.akka.stream.RateLogger$Tick$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class RateLogger$ {
    public static final RateLogger$ MODULE$ = new RateLogger$();

    public <T> Flow<T, T, ?> apply(String name, FiniteDuration tick, Option<Tuple2<Object, Object>> total, boolean skipNoopLogs, IzLogger log, CodePosition pos) {
        Source ticker = Source$.MODULE$.tick(tick, tick, (Object)package$.MODULE$.Left().apply((Object)RateLogger$Tick$.MODULE$));
        Sink rateLogger = Sink$.MODULE$.fold((Object)new RateLogger.Stats(RateLogger$Stats$.MODULE$.apply$default$1(), RateLogger$Stats$.MODULE$.apply$default$2(), RateLogger$Stats$.MODULE$.apply$default$3(), RateLogger$Stats$.MODULE$.apply$default$4()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                RateLogger.Stats stats = (RateLogger.Stats)tuple2._1();
                Either either = (Either)tuple2._2();
                if (stats != null) {
                    long allCount = stats.allCount();
                    long allStart = stats.allStart();
                    long periodCount = stats.periodCount();
                    long periodStart = stats.periodStart();
                    if (either instanceof Left) {
                        long periodDuration = System.currentTimeMillis() - periodStart;
                        long allDuration = System.currentTimeMillis() - allStart;
                        BigDecimal rate1s = package$.MODULE$.BigDecimal().apply(periodCount).$div(package$.MODULE$.BigDecimal().apply(MODULE$.LongNonZero(periodDuration).nonZero()).$div(BigDecimal$.MODULE$.int2bigDecimal(1000))).setScale(2, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
                        BigDecimal rateAll = package$.MODULE$.BigDecimal().apply(allCount).$div(package$.MODULE$.BigDecimal().apply(MODULE$.LongNonZero(allDuration).nonZero()).$div(BigDecimal$.MODULE$.int2bigDecimal(1000))).setScale(2, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
                        Log.Message message = new Log.Message(new StringContext((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", "/s ", "/s ", ""}))), (Seq)new .colon.colon((Object)Log.LogArg$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tag"})), (Object)"stats", false, (Option)new Some((Object)LogstageCodec$.MODULE$.LogstageCodecString())), (List)new .colon.colon((Object)Log.LogArg$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"})), (Object)name, false, (Option)new Some((Object)LogstageCodec$.MODULE$.LogstageCodecString())), (List)new .colon.colon((Object)Log.LogArg$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rate1s"})), (Object)rate1s, false, (Option)new Some((Object)LogstageCodec$.MODULE$.LogstageCodecBigDecimal())), (List)new .colon.colon((Object)Log.LogArg$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rateAll"})), (Object)rateAll, false, (Option)new Some((Object)LogstageCodec$.MODULE$.LogstageCodecBigDecimal())), (List)new .colon.colon((Object)Log.LogArg$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"stageDone"})), (Object)BoxesRunTime.boxToLong((long)allCount), false, (Option)new Some((Object)LogstageCodec$.MODULE$.LogstageCodecLong())), (List)Nil$.MODULE$)))))).$plus((Log.Message)total.fold((Function0 & Serializable)() -> Log.Message$.MODULE$.empty(), (Function1 & Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            long stage = tuple2._1$mcJ$sp();
                            long overall = tuple2._2$mcJ$sp();
                            long overallDone = overall - stage + allCount;
                            BigDecimal overallDonePercent = package$.MODULE$.BigDecimal().apply(overallDone).$div(BigDecimal$.MODULE$.long2bigDecimal(MODULE$.LongNonZero(overall).nonZero())).$times(BigDecimal$.MODULE$.int2bigDecimal(100)).setScale(2, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
                            BigDecimal stageDonePercent = package$.MODULE$.BigDecimal().apply(allCount).$div(BigDecimal$.MODULE$.long2bigDecimal(MODULE$.LongNonZero(stage).nonZero())).$times(BigDecimal$.MODULE$.int2bigDecimal(100)).setScale(2, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
                            long stageLeft = stage - allCount;
                            BigDecimal estimatedSecondsLeft = BigDecimal$.MODULE$.long2bigDecimal(stageLeft).$div(MODULE$.BigDecimalNonZero(rateAll).nonZero()).setScale(0, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
                            Log.Message message = new Log.Message(new StringContext((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" ", " ", " ", "% ", " ", "% ", ""}))), (Seq)new .colon.colon((Object)Log.LogArg$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"stageTotal"})), (Object)BoxesRunTime.boxToLong((long)stage), false, (Option)new Some((Object)LogstageCodec$.MODULE$.LogstageCodecLong())), (List)new .colon.colon((Object)Log.LogArg$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"stageLeft"})), (Object)BoxesRunTime.boxToLong((long)stageLeft), false, (Option)new Some((Object)LogstageCodec$.MODULE$.LogstageCodecLong())), (List)new .colon.colon((Object)Log.LogArg$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"stageDonePercent"})), (Object)stageDonePercent, false, (Option)new Some((Object)LogstageCodec$.MODULE$.LogstageCodecBigDecimal())), (List)new .colon.colon((Object)Log.LogArg$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"overallDone"})), (Object)BoxesRunTime.boxToLong((long)overallDone), false, (Option)new Some((Object)LogstageCodec$.MODULE$.LogstageCodecLong())), (List)new .colon.colon((Object)Log.LogArg$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"overallDonePercent"})), (Object)overallDonePercent, false, (Option)new Some((Object)LogstageCodec$.MODULE$.LogstageCodecBigDecimal())), (List)new .colon.colon((Object)Log.LogArg$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"estimatedSecondsLeft"})), (Object)estimatedSecondsLeft, false, (Option)new Some((Object)LogstageCodec$.MODULE$.LogstageCodecBigDecimal())), (List)Nil$.MODULE$)))))));
                            return message;
                        }));
                        if (skipNoopLogs) {
                            if (periodCount <= 0L) return new RateLogger.Stats(allCount, allStart, RateLogger$Stats$.MODULE$.apply$default$3(), RateLogger$Stats$.MODULE$.apply$default$4());
                        }
                        log.log((Log.Level)Log.Level$.Info$.MODULE$, (Function0 & Serializable)() -> message, pos);
                        return new RateLogger.Stats(allCount, allStart, RateLogger$Stats$.MODULE$.apply$default$3(), RateLogger$Stats$.MODULE$.apply$default$4());
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            RateLogger.Stats stats = (RateLogger.Stats)tuple2._1();
            Either either = (Either)tuple2._2();
            if (!(either instanceof Right)) throw new MatchError((Object)tuple2);
            long x$1 = stats.periodCount() + 1L;
            long x$2 = stats.allCount() + 1L;
            long x$3 = stats.copy$default$2();
            long x$4 = stats.copy$default$4();
            return stats.copy(x$2, x$3, x$1, x$4);
        });
        return (Flow)Flow$.MODULE$.apply().wireTap((Graph)((Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)x$1 -> package$.MODULE$.Right().apply(x$1)).merge((Graph)ticker, true)).to((Graph)rateLogger).withAttributes(ActorAttributes$.MODULE$.supervisionStrategy(Supervision$.MODULE$.resumingDecider())));
    }

    public <T> FiniteDuration apply$default$2() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
    }

    public <T> Option<Tuple2<Object, Object>> apply$default$3() {
        return None$.MODULE$;
    }

    public <T> boolean apply$default$4() {
        return true;
    }

    public RateLogger.IntNonZero IntNonZero(int x) {
        return new RateLogger.IntNonZero(x);
    }

    public RateLogger.LongNonZero LongNonZero(long x) {
        return new RateLogger.LongNonZero(x);
    }

    public RateLogger.BigDecimalNonZero BigDecimalNonZero(BigDecimal x) {
        return new RateLogger.BigDecimalNonZero(x);
    }

    private RateLogger$() {
    }
}

