/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.zone.ZoneMap;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Set;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.ArrayOps$;
import scala.scalajs.js.Dictionary;
import scala.scalajs.js.Dynamic;
import zonedb.java.tzdb$;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001B\u0007\u000f\u0005UAQA\u0007\u0001\u0005\u0002mAq!\b\u0001C\u0002\u0013%a\u0004\u0003\u0004=\u0001\u0001\u0006Ia\b\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019!\u0005\u0001)A\u0005\u007f!)Q\t\u0001C)\r\")Q\n\u0001C\u0005\u001d\")Q\u000b\u0001C\u0005-\")q\f\u0001C\u0005A\")a\r\u0001C\u0005O\")A\u000e\u0001C)[\")Q\u000f\u0001C)m\n)BK\u001f3c5>tWMU;mKN\u0004&o\u001c<jI\u0016\u0014(BA\b\u0011\u0003\u0011QxN\\3\u000b\u0005E\u0011\u0012\u0001\u0002;j[\u0016T\u0011aE\u0001\u0005U\u00064\u0018m\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u0019\u001b\u0005q\u0011BA\r\u000f\u0005EQvN\\3Sk2,7\u000f\u0015:pm&$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"a\u0006\u0001\u0002\u0017M$HMW8oKNl\u0015\r]\u000b\u0002?A!\u0001eJ\u00155\u001b\u0005\t#B\u0001\u0012$\u0003%IW.\\;uC\ndWM\u0003\u0002%K\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0011\u0003\u00075\u000b\u0007\u000f\u0005\u0002+c9\u00111f\f\t\u0003Y\u0015j\u0011!\f\u0006\u0003]Q\ta\u0001\u0010:p_Rt\u0014B\u0001\u0019&\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A*\u0003CA\u001b;\u001b\u00051$BA\u001c9\u0003\tQ7O\u0003\u0002:K\u000591oY1mC*\u001c\u0018BA\u001e7\u0005\u001d!\u0015P\\1nS\u000e\fAb\u001d;e5>tWm]'ba\u0002\nQBZ5yK\u0012TvN\\3t\u001b\u0006\u0004X#A \u0011\t\u0001:\u0013\u0006\u0011\t\u0003\u0003\nk\u0011!J\u0005\u0003\u0007\u0016\u00121!\u00138u\u000391\u0017\u000e_3e5>tWm]'ba\u0002\na\u0002\u001d:pm&$WMW8oK&#7\u000fF\u0001H!\rA5*K\u0007\u0002\u0013*\u0011!JE\u0001\u0005kRLG.\u0003\u0002M\u0013\n\u00191+\u001a;\u0002\u0017Q|Gj\\2bYRKW.\u001a\u000b\u0003\u001fN\u0003\"\u0001U)\u000e\u0003AI!A\u0015\t\u0003\u00131{7-\u00197US6,\u0007\"\u0002+\b\u0001\u0004\u0001\u0015A\u00017u\u0003Y!xNW8oK>3gm]3u)J\fgn]5uS>tGCA,[!\t9\u0002,\u0003\u0002Z\u001d\t!\"l\u001c8f\u001f\u001a47/\u001a;Ue\u0006t7/\u001b;j_:DQa\u0017\u0005A\u0002q\u000b!A\u001f:\u0011\u0007Uj\u0006)\u0003\u0002_m\t)\u0011I\u001d:bs\u0006QBo\u001c.p]\u0016|eMZ:fiR\u0013\u0018M\\:ji&|gNU;mKR\u0011\u0011\r\u001a\t\u0003/\tL!a\u0019\b\u00031i{g.Z(gMN,G\u000f\u0016:b]NLG/[8o%VdW\rC\u0003f\u0013\u0001\u0007A,A\u0002{_J\f1\u0002^8[_:,'+\u001e7fgR\u0011\u0001n\u001b\t\u0003/%L!A\u001b\b\u0003\u0013i{g.\u001a*vY\u0016\u001c\b\"B.\u000b\u0001\u0004!\u0014\u0001\u00049s_ZLG-\u001a*vY\u0016\u001cHc\u00015oa\")qn\u0003a\u0001S\u0005A!/Z4j_:LE\rC\u0003r\u0017\u0001\u0007!/\u0001\u0006g_J\u001c\u0015m\u00195j]\u001e\u0004\"!Q:\n\u0005Q,#a\u0002\"p_2,\u0017M\\\u0001\u0010aJ|g/\u001b3f-\u0016\u00148/[8ogR\u0011qO\u001f\t\u0005\u0011bL\u0003.\u0003\u0002z\u0013\naa*\u0019<jO\u0006\u0014G.Z'ba\")1\u0010\u0004a\u0001S\u00051!p\u001c8f\u0013\u0012D#\u0001A?\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0015\u0005tgn\u001c;bi&|gNC\u0002\u0002\u0006a\nqA]3gY\u0016\u001cG/C\u0002\u0002\n}\u0014Q$\u00128bE2,'+\u001a4mK\u000e$\u0018N^3J]N$\u0018M\u001c;jCRLwN\u001c")
public final class TzdbZoneRulesProvider
extends ZoneRulesProvider {
    private final Map<String, Dynamic> stdZonesMap = Any$.MODULE$.wrapDictionary((Dictionary)tzdb$.MODULE$.stdZones()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private final Map<String, Object> fixedZonesMap = Any$.MODULE$.wrapDictionary((Dictionary)tzdb$.MODULE$.fixedZones()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());

    private Map<String, Dynamic> stdZonesMap() {
        return this.stdZonesMap;
    }

    private Map<String, Object> fixedZonesMap() {
        return this.fixedZonesMap;
    }

    @Override
    public Set<String> provideZoneIds() {
        HashSet<String> zones = new HashSet<String>();
        scala.collection.immutable.Set zonesSet = (scala.collection.immutable.Set)this.stdZonesMap().keySet().$plus$plus((IterableOnce)this.fixedZonesMap().keySet()).$plus$plus((IterableOnce)tzdb$.MODULE$.zoneLinks().keySet());
        zonesSet.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)zones.add(x$1)));
        zones.remove("GMT0");
        zones.remove("GMT+0");
        zones.remove("GMT-0");
        return zones;
    }

    private LocalTime toLocalTime(int lt) {
        return LocalTime.ofSecondOfDay(lt);
    }

    private ZoneOffsetTransition toZoneOffsetTransition(Array<Object> zr) {
        int jointDate = BoxesRunTime.unboxToInt((Object)zr.apply(0));
        int year = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(Integer.toString(jointDate).substring(0, 4)));
        int dayOfYear = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(Integer.toString(jointDate).substring(4, 7)));
        LocalDateTime transition = LocalDateTime.of(LocalDate.ofYearDay(year, dayOfYear), this.toLocalTime(BoxesRunTime.unboxToInt((Object)zr.apply(1))));
        return ZoneOffsetTransition.of(transition, ZoneOffset.ofTotalSeconds(BoxesRunTime.unboxToInt((Object)zr.apply(2))), ZoneOffset.ofTotalSeconds(BoxesRunTime.unboxToInt((Object)zr.apply(3))));
    }

    private ZoneOffsetTransitionRule toZoneOffsetTransitionRule(Array<Object> zor) {
        LocalTime time = this.toLocalTime(BoxesRunTime.unboxToInt((Object)zor.apply(3)));
        DayOfWeek dayOfWeek = BoxesRunTime.unboxToInt((Object)zor.apply(2)) >= 0 ? DayOfWeek.of(BoxesRunTime.unboxToInt((Object)zor.apply(2))) : null;
        return ZoneOffsetTransitionRule.of(Month.of(BoxesRunTime.unboxToInt((Object)zor.apply(0))), BoxesRunTime.unboxToInt((Object)zor.apply(1)), dayOfWeek, time, BoxesRunTime.unboxToInt((Object)zor.apply(4)) == 1, ZoneOffsetTransitionRule.TimeDefinition.values()[BoxesRunTime.unboxToInt((Object)zor.apply(5))], ZoneOffset.ofTotalSeconds(BoxesRunTime.unboxToInt((Object)zor.apply(6))), ZoneOffset.ofTotalSeconds(BoxesRunTime.unboxToInt((Object)zor.apply(7))), ZoneOffset.ofTotalSeconds(BoxesRunTime.unboxToInt((Object)zor.apply(8))));
    }

    private ZoneRules toZoneRules(Dynamic zr2) {
        ZoneOffset bso = ZoneOffset.ofTotalSeconds(BoxesRunTime.unboxToInt((Object)zr2.selectDynamic("s")));
        ZoneOffset bwo = ZoneOffset.ofTotalSeconds(BoxesRunTime.unboxToInt((Object)zr2.selectDynamic("w")));
        Array standardTransitions = ArrayOps$.MODULE$.map$extension(Any$.MODULE$.jsArrayOps((Array)zr2.selectDynamic("t")), (Function1 & Serializable)zr -> this.toZoneOffsetTransition((Array<Object>)zr));
        Array transitionList = ArrayOps$.MODULE$.map$extension(Any$.MODULE$.jsArrayOps((Array)zr2.selectDynamic("l")), (Function1 & Serializable)zr -> this.toZoneOffsetTransition((Array<Object>)zr));
        Array lastRules = ArrayOps$.MODULE$.map$extension(Any$.MODULE$.jsArrayOps((Array)zr2.selectDynamic("r")), (Function1 & Serializable)zor -> this.toZoneOffsetTransitionRule((Array<Object>)zor));
        ArrayList<ZoneOffsetTransition> standardTransitionsJ = new ArrayList<ZoneOffsetTransition>();
        Any$.MODULE$.wrapArray(standardTransitions).toList().foreach((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)standardTransitionsJ.add(x$2)));
        ArrayList<ZoneOffsetTransition> transitionListJ = new ArrayList<ZoneOffsetTransition>();
        Any$.MODULE$.wrapArray(transitionList).toList().foreach((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)transitionListJ.add(x$3)));
        ArrayList<ZoneOffsetTransitionRule> lastRulesJ = new ArrayList<ZoneOffsetTransitionRule>();
        Any$.MODULE$.wrapArray(lastRules).toList().foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)lastRulesJ.add(x$4)));
        return ZoneRules.of(bso, bwo, standardTransitionsJ, transitionListJ, lastRulesJ);
    }

    @Override
    public ZoneRules provideRules(String regionId, boolean forCaching) {
        String actualRegion = (String)tzdb$.MODULE$.zoneLinks().getOrElse((Object)regionId, (Function0 & Serializable)() -> regionId);
        return (ZoneRules)this.stdZonesMap().get((Object)actualRegion).map((Function1 & Serializable)zr -> this.toZoneRules((Dynamic)zr)).orElse((Function0 & Serializable)() -> this.fixedZonesMap().get((Object)actualRegion).map((Function1 & Serializable)i -> TzdbZoneRulesProvider.$anonfun$provideRules$4(BoxesRunTime.unboxToInt((Object)i)))).getOrElse((Function0 & Serializable)() -> {
            throw new DateTimeException(new StringBuilder(24).append("TimeZone Region ").append(actualRegion).append(" unknown").toString());
        });
    }

    @Override
    public NavigableMap<String, ZoneRules> provideVersions(String zoneId) {
        String actualRegion = (String)tzdb$.MODULE$.zoneLinks().getOrElse((Object)zoneId, (Function0 & Serializable)() -> zoneId);
        return (NavigableMap)this.stdZonesMap().get((Object)actualRegion).map((Function1 & Serializable)zr -> this.toZoneRules((Dynamic)zr)).orElse((Function0 & Serializable)() -> this.fixedZonesMap().get((Object)actualRegion).map((Function1 & Serializable)i -> TzdbZoneRulesProvider.$anonfun$provideVersions$4(BoxesRunTime.unboxToInt((Object)i)))).map((Function1 & Serializable)z -> {
            ZoneMap r = new ZoneMap(ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering.String$.MODULE$);
            r.put((Object)tzdb$.MODULE$.version(), z);
            return r;
        }).getOrElse((Function0 & Serializable)() -> {
            throw new DateTimeException(new StringBuilder(24).append("TimeZone Region ").append(actualRegion).append(" unknown").toString());
        });
    }

    public static final /* synthetic */ ZoneRules $anonfun$provideRules$4(int i) {
        return ZoneRules.of(ZoneOffset.ofTotalSeconds(i));
    }

    public static final /* synthetic */ ZoneRules $anonfun$provideVersions$4(int i) {
        return ZoneRules.of(ZoneOffset.ofTotalSeconds(i));
    }
}

