/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.crossbrowsertesting;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.serenitybdd.core.webdriver.OverrideDriverCapabilities;
import net.serenitybdd.core.webdriver.enhancers.BeforeAWebdriverScenario;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BeforeACrossBrowserTestingScenario
implements BeforeAWebdriverScenario {
    private static final String CROSS_BROWSER_TESTING = "crossbrowsertesting.";
    private static final List<String> NON_CBT_PROPERTIES = Arrays.asList("user", "key", "browserName", "browserVersion", "platformName");

    public MutableCapabilities apply(EnvironmentVariables environmentVariables, SupportedWebDriver driver, TestOutcome testOutcome, MutableCapabilities capabilities) {
        if (driver != SupportedWebDriver.REMOTE) {
            return capabilities;
        }
        String remotePlatform = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{"remote.platform"}).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)remotePlatform) && capabilities instanceof DesiredCapabilities) {
            ((DesiredCapabilities)capabilities).setPlatform(Platform.valueOf((String)remotePlatform.toUpperCase()));
        }
        Properties cbtProperties = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getPropertiesWithPrefix(CROSS_BROWSER_TESTING);
        OverrideDriverCapabilities.getProperties().forEach((key, value) -> cbtProperties.setProperty((String)key, value.toString()));
        this.setNonW3CCapabilities(capabilities, cbtProperties);
        Map<String, Object> cbtOptions = this.w3CPropertyMapFrom(cbtProperties);
        String testName = testOutcome.getStoryTitle() + " - " + testOutcome.getTitle();
        cbtOptions.put("name", testName);
        capabilities.setCapability("cbt:options", cbtOptions);
        return capabilities;
    }

    private void setNonW3CCapabilities(MutableCapabilities capabilities, Properties cbtProperties) {
        cbtProperties.stringPropertyNames().stream().filter(this::isNonW3CProperty).forEach(key -> capabilities.setCapability(this.unprefixed((String)key), cbtProperties.getProperty((String)key)));
    }

    private Map<String, Object> w3CPropertyMapFrom(Properties properties) {
        HashMap<String, Object> w3cOptions = new HashMap<String, Object>();
        HashMap nestedOptions = new HashMap();
        properties.stringPropertyNames().stream().filter(this::isW3CProperty).forEach(key -> {
            String unprefixedKey = this.unprefixed((String)key);
            w3cOptions.put(unprefixedKey, properties.getProperty((String)key));
        });
        w3cOptions.putAll(nestedOptions);
        return w3cOptions;
    }

    private boolean isNonW3CProperty(String key) {
        return NON_CBT_PROPERTIES.contains(this.unprefixed(key));
    }

    private boolean isW3CProperty(String key) {
        return !this.isNonW3CProperty(key);
    }

    private String unprefixed(String propertyName) {
        return propertyName.replace(CROSS_BROWSER_TESTING, "");
    }
}

