/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.filter.Filters;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.options.CucumberOptionsAnnotationParser;
import io.cucumber.core.options.CucumberProperties;
import io.cucumber.core.options.CucumberPropertiesParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PluginFactory;
import io.cucumber.core.plugin.Plugins;
import io.cucumber.core.plugin.SerenityReporter;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.runtime.BackendServiceLoader;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.core.runtime.FeatureSupplier;
import io.cucumber.core.runtime.ObjectFactoryServiceLoader;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.core.runtime.Runtime;
import io.cucumber.core.runtime.ScanningTypeRegistryConfigurerSupplier;
import io.cucumber.core.runtime.ThreadLocalObjectFactorySupplier;
import io.cucumber.core.runtime.ThreadLocalRunnerSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.core.runtime.TypeRegistryConfigurerSupplier;
import io.cucumber.junit.Assertions;
import io.cucumber.junit.FeatureRunner;
import io.cucumber.junit.FeatureRunnerExtractors;
import io.cucumber.junit.JUnitCucumberOptionsProvider;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.JUnitOptionsParser;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.serenitybdd.cucumber.suiteslicing.CucumberSuiteSlicer;
import net.serenitybdd.cucumber.suiteslicing.ScenarioFilter;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenarios;
import net.serenitybdd.cucumber.util.PathUtils;
import net.serenitybdd.cucumber.util.Splitter;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberSerenityRunner
extends ParentRunner<ParentRunner<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberSerenityRunner.class);
    private List<ParentRunner<?>> children = new ArrayList();
    private final EventBus bus;
    private static ThreadLocal<RuntimeOptions> RUNTIME_OPTIONS = new ThreadLocal();
    private final List<Feature> features;
    private final Plugins plugins;
    private boolean multiThreadingAssumed = false;
    private static RuntimeOptions DEFAULT_RUNTIME_OPTIONS;

    public CucumberSerenityRunner(Class clazz) throws InitializationError {
        super(clazz);
        Assertions.assertNoCucumberAnnotatedMethods((Class)clazz);
        RuntimeOptions propertiesFileOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromPropertiesFile()).build();
        RuntimeOptions annotationOptions = new CucumberOptionsAnnotationParser().withOptionsProvider((CucumberOptionsAnnotationParser.OptionsProvider)new JUnitCucumberOptionsProvider()).parse(clazz).build(propertiesFileOptions);
        RuntimeOptions environmentOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromEnvironment()).build(annotationOptions);
        RuntimeOptions runtimeOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromSystemProperties()).addDefaultSummaryPrinterIfAbsent().build(environmentOptions);
        if (!runtimeOptions.isStrict()) {
            LOGGER.warn("By default Cucumber is running in --non-strict mode.\nThis default will change to --strict and --non-strict will be removed.\nYou can use --strict or @CucumberOptions(strict = true) to suppress this warning");
        }
        RuntimeOptionsBuilder runtimeOptionsBuilder = new RuntimeOptionsBuilder();
        Collection<String> tagFilters = CucumberSerenityRunner.environmentSpecifiedTags(runtimeOptions.getTagExpressions());
        for (String tagFilter : tagFilters) {
            runtimeOptionsBuilder.addTagFilter(tagFilter);
        }
        runtimeOptionsBuilder.build(runtimeOptions);
        JUnitOptions junitPropertiesFileOptions = new JUnitOptionsParser().parse(CucumberProperties.fromPropertiesFile()).build();
        JUnitOptions junitAnnotationOptions = new JUnitOptionsParser().parse(clazz).build(junitPropertiesFileOptions);
        JUnitOptions junitEnvironmentOptions = new JUnitOptionsParser().parse(CucumberProperties.fromEnvironment()).build(junitAnnotationOptions);
        JUnitOptions junitOptions = new JUnitOptionsParser().parse(CucumberProperties.fromSystemProperties()).setStrict(runtimeOptions.isStrict()).build(junitEnvironmentOptions);
        this.bus = new TimeServiceEventBus(Clock.systemUTC(), UUID::randomUUID);
        CucumberSerenityRunner.setRuntimeOptions(runtimeOptions);
        FeatureParser parser = new FeatureParser(() -> ((EventBus)this.bus).generateId());
        Supplier<ClassLoader> classLoader = ClassLoaders::getDefaultClassLoader;
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(classLoader, (io.cucumber.core.feature.Options)runtimeOptions, parser);
        this.features = featureSupplier.get();
        this.plugins = new Plugins(new PluginFactory(), (Options)runtimeOptions);
        Configuration systemConfiguration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        SerenityReporter reporter = new SerenityReporter(systemConfiguration);
        CucumberSerenityRunner.addSerenityReporterPlugin(this.plugins, reporter);
        ObjectFactoryServiceLoader objectFactoryServiceLoader = new ObjectFactoryServiceLoader((io.cucumber.core.backend.Options)runtimeOptions);
        ThreadLocalObjectFactorySupplier objectFactorySupplier = new ThreadLocalObjectFactorySupplier(objectFactoryServiceLoader);
        BackendServiceLoader backendSupplier = new BackendServiceLoader(clazz::getClassLoader, (ObjectFactorySupplier)objectFactorySupplier);
        ScanningTypeRegistryConfigurerSupplier typeRegistryConfigurerSupplier = new ScanningTypeRegistryConfigurerSupplier(classLoader, (io.cucumber.core.runner.Options)runtimeOptions);
        ThreadLocalRunnerSupplier runnerSupplier = new ThreadLocalRunnerSupplier((io.cucumber.core.runner.Options)runtimeOptions, this.bus, (BackendSupplier)backendSupplier, (ObjectFactorySupplier)objectFactorySupplier, (TypeRegistryConfigurerSupplier)typeRegistryConfigurerSupplier);
        Filters filters = new Filters((io.cucumber.core.filter.Options)runtimeOptions);
        this.children = this.features.stream().map(arg_0 -> CucumberSerenityRunner.lambda$new$0((Predicate)filters, runnerSupplier, junitOptions, arg_0)).filter(runner -> !runner.isEmpty()).collect(Collectors.toList());
    }

    public static void setRuntimeOptions(RuntimeOptions runtimeOptions) {
        RUNTIME_OPTIONS.set(runtimeOptions);
        DEFAULT_RUNTIME_OPTIONS = runtimeOptions;
    }

    public static RuntimeOptions currentRuntimeOptions() {
        return RUNTIME_OPTIONS.get() != null ? RUNTIME_OPTIONS.get() : DEFAULT_RUNTIME_OPTIONS;
    }

    private static Collection<String> environmentSpecifiedTags(List<?> existingTags) {
        EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        String tagsExpression = ThucydidesSystemProperty.TAGS.from(environmentVariables, "");
        List existingTagsValues = existingTags.stream().map(Object::toString).collect(Collectors.toList());
        return Splitter.on(",").trimResults().omitEmptyStrings().splitToList(tagsExpression).stream().map(CucumberSerenityRunner::toCucumberTag).filter(t -> !existingTagsValues.contains(t)).collect(Collectors.toList());
    }

    private static String toCucumberTag(String from) {
        String tag = from.replaceAll(":", "=");
        if (tag.startsWith("~@") || tag.startsWith("@")) {
            return tag;
        }
        if (tag.startsWith("~")) {
            return "~@" + tag.substring(1);
        }
        return "@" + tag;
    }

    public static Runtime createSerenityEnabledRuntime(Supplier<ClassLoader> classLoaderSupplier, RuntimeOptions runtimeOptions, Configuration systemConfiguration) {
        RuntimeOptionsBuilder runtimeOptionsBuilder = new RuntimeOptionsBuilder();
        Collection<String> allTagFilters = CucumberSerenityRunner.environmentSpecifiedTags(runtimeOptions.getTagExpressions());
        for (String tagFilter : allTagFilters) {
            runtimeOptionsBuilder.addTagFilter(tagFilter);
        }
        runtimeOptionsBuilder.build(runtimeOptions);
        CucumberSerenityRunner.setRuntimeOptions(runtimeOptions);
        TimeServiceEventBus bus = new TimeServiceEventBus(Clock.systemUTC(), UUID::randomUUID);
        FeatureParser parser = new FeatureParser(() -> ((EventBus)bus).generateId());
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(classLoaderSupplier, (io.cucumber.core.feature.Options)runtimeOptions, parser);
        SerenityReporter serenityReporter = new SerenityReporter(systemConfiguration);
        Runtime runtime = Runtime.builder().withClassLoader(classLoaderSupplier).withRuntimeOptions(runtimeOptions).withAdditionalPlugins(new Plugin[]{serenityReporter}).withEventBus((EventBus)bus).withFeatureSupplier((FeatureSupplier)featureSupplier).build();
        return runtime;
    }

    private static void addSerenityReporterPlugin(Plugins plugins, SerenityReporter plugin) {
        for (Plugin currentPlugin : plugins.getPlugins()) {
            if (!(currentPlugin instanceof SerenityReporter)) continue;
            return;
        }
        plugins.addPlugin((Plugin)plugin);
    }

    protected Description describeChild(ParentRunner<?> child) {
        return child.getDescription();
    }

    protected void runChild(ParentRunner<?> child, RunNotifier notifier) {
        child.run(notifier);
    }

    protected Statement childrenInvoker(RunNotifier notifier) {
        Statement runFeatures = super.childrenInvoker(notifier);
        return new RunCucumber(runFeatures);
    }

    public void setScheduler(RunnerScheduler scheduler) {
        super.setScheduler(scheduler);
        this.multiThreadingAssumed = true;
    }

    public List<ParentRunner<?>> getChildren() {
        try {
            EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
            RuntimeOptions runtimeOptions = CucumberSerenityRunner.currentRuntimeOptions();
            List tagFilters = runtimeOptions.getTagExpressions();
            List featurePaths = runtimeOptions.getFeaturePaths();
            int batchNumber = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_BATCH_NUMBER, Integer.valueOf(1));
            int batchCount = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_BATCH_COUNT, Integer.valueOf(1));
            int forkNumber = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_FORK_NUMBER, Integer.valueOf(1));
            int forkCount = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_FORK_COUNT, Integer.valueOf(1));
            if (batchCount == 1 && forkCount == 1) {
                return this.children;
            }
            LOGGER.info("Running slice {} of {} using fork {} of {} from feature paths {}", new Object[]{batchNumber, batchCount, forkNumber, forkCount, featurePaths});
            WeightedCucumberScenarios weightedCucumberScenarios = new CucumberSuiteSlicer(featurePaths, TestStatistics.from(environmentVariables, featurePaths)).scenarios(batchNumber, batchCount, forkNumber, forkCount, tagFilters);
            List<ParentRunner<?>> unfilteredChildren = this.children;
            AtomicInteger filteredInScenarioCount = new AtomicInteger();
            List<ParentRunner<?>> filteredChildren = unfilteredChildren.stream().filter(this.forIncludedFeatures(weightedCucumberScenarios)).map(this.toPossibleFeatureRunner(weightedCucumberScenarios, filteredInScenarioCount)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            if (filteredInScenarioCount.get() != weightedCucumberScenarios.totalScenarioCount()) {
                LOGGER.warn("There is a mismatch between the number of scenarios included in this test run ({}) and the expected number of scenarios loaded ({}). This suggests that the scenario filtering is not working correctly or feature file(s) of an unexpected structure are being run", (Object)filteredInScenarioCount.get(), (Object)weightedCucumberScenarios.scenarios.size());
            }
            LOGGER.info("Running {} of {} features", (Object)filteredChildren.size(), (Object)unfilteredChildren.size());
            return filteredChildren;
        }
        catch (Exception e) {
            LOGGER.error("Test failed to start", (Throwable)e);
            throw e;
        }
    }

    private Function<ParentRunner<?>, Optional<ParentRunner<?>>> toPossibleFeatureRunner(WeightedCucumberScenarios weightedCucumberScenarios, AtomicInteger filteredInScenarioCount) {
        return featureRunner -> {
            int initialScenarioCount = featureRunner.getDescription().getChildren().size();
            String featureName = FeatureRunnerExtractors.extractFeatureName(featureRunner);
            try {
                ScenarioFilter filter = weightedCucumberScenarios.createFilterContainingScenariosIn(featureName);
                String featurePath = FeatureRunnerExtractors.featurePathFor(featureRunner);
                featureRunner.filter((Filter)filter);
                if (!filter.scenariosIncluded().isEmpty()) {
                    LOGGER.info("{} scenario(s) included for '{}' in {}", new Object[]{filter.scenariosIncluded().size(), featureName, featurePath});
                    filter.scenariosIncluded().forEach(scenario -> {
                        LOGGER.info("Included scenario '{}'", scenario);
                        filteredInScenarioCount.getAndIncrement();
                    });
                }
                if (!filter.scenariosExcluded().isEmpty()) {
                    LOGGER.debug("{} scenario(s) excluded for '{}' in {}", new Object[]{filter.scenariosExcluded().size(), featureName, featurePath});
                    filter.scenariosExcluded().forEach(scenario -> LOGGER.debug("Excluded scenario '{}'", scenario));
                }
                return Optional.of(featureRunner);
            }
            catch (NoTestsRemainException e) {
                LOGGER.info("Filtered out all {} scenarios for feature '{}'", (Object)initialScenarioCount, (Object)featureName);
                return Optional.empty();
            }
        };
    }

    private Predicate<ParentRunner<?>> forIncludedFeatures(WeightedCucumberScenarios weightedCucumberScenarios) {
        return featureRunner -> {
            String featureName = FeatureRunnerExtractors.extractFeatureName(featureRunner);
            String featurePath = PathUtils.getAsFile(FeatureRunnerExtractors.featurePathFor(featureRunner)).getName();
            boolean matches = weightedCucumberScenarios.scenarios.stream().anyMatch(scenario -> featurePath.equals(scenario.featurePath));
            LOGGER.debug("{} in filtering '{}' in {}", new Object[]{matches ? "Including" : "Not including", featureName, featurePath});
            return matches;
        };
    }

    private static /* synthetic */ FeatureRunner lambda$new$0(Predicate filters, ThreadLocalRunnerSupplier runnerSupplier, JUnitOptions junitOptions, Feature feature) {
        return FeatureRunner.create((Feature)feature, (Predicate)filters, (RunnerSupplier)runnerSupplier, (JUnitOptions)junitOptions);
    }

    class RunCucumber
    extends Statement {
        private final Statement runFeatures;

        RunCucumber(Statement runFeatures) {
            this.runFeatures = runFeatures;
        }

        public void evaluate() throws Throwable {
            if (CucumberSerenityRunner.this.multiThreadingAssumed) {
                CucumberSerenityRunner.this.plugins.setSerialEventBusOnEventListenerPlugins((EventPublisher)CucumberSerenityRunner.this.bus);
            } else {
                CucumberSerenityRunner.this.plugins.setEventBusOnEventListenerPlugins((EventPublisher)CucumberSerenityRunner.this.bus);
            }
            CucumberSerenityRunner.this.bus.send((Event)new TestRunStarted(CucumberSerenityRunner.this.bus.getInstant()));
            for (Feature feature : CucumberSerenityRunner.this.features) {
                CucumberSerenityRunner.this.bus.send((Event)new TestSourceRead(CucumberSerenityRunner.this.bus.getInstant(), feature.getUri(), feature.getSource()));
            }
            this.runFeatures.evaluate();
            CucumberSerenityRunner.this.bus.send((Event)new TestRunFinished(CucumberSerenityRunner.this.bus.getInstant()));
        }
    }
}

