/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import com.google.common.collect.FluentIterable;
import io.cucumber.core.internal.gherkin.ast.Feature;
import io.cucumber.core.internal.gherkin.ast.Scenario;
import io.cucumber.core.internal.gherkin.ast.ScenarioDefinition;
import io.cucumber.core.internal.gherkin.ast.ScenarioOutline;
import io.cucumber.core.internal.gherkin.ast.Tag;
import io.cucumber.core.plugin.FeatureFileLoader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenario;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenarios;
import net.serenitybdd.cucumber.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberScenarioLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberScenarioLoader.class);
    private final List<URI> featurePaths;
    private final TestStatistics statistics;
    private Map<Feature, URI> mapsForFeatures = new HashMap<Feature, URI>();

    public CucumberScenarioLoader(List<URI> featurePaths, TestStatistics statistics) {
        this.featurePaths = featurePaths;
        this.statistics = statistics;
    }

    public WeightedCucumberScenarios load() {
        LOGGER.debug("Feature paths are {}", this.featurePaths);
        List<WeightedCucumberScenario> weightedCucumberScenarios = this.featurePaths.stream().map(featurePath -> new FeatureFileLoader().getFeature((URI)featurePath)).map(this.getScenarios()).flatMap(Collection::stream).collect(Collectors.toList());
        this.featurePaths.stream().collect(Collectors.toMap(f -> f, featurePath -> new FeatureFileLoader().getFeature((URI)featurePath)));
        return new WeightedCucumberScenarios(weightedCucumberScenarios);
    }

    private Function<Feature, List<WeightedCucumberScenario>> getScenarios() {
        return cucumberFeature -> {
            try {
                return cucumberFeature == null ? Collections.emptyList() : cucumberFeature.getChildren().stream().filter(child -> Arrays.asList(ScenarioOutline.class, Scenario.class).contains(child.getClass())).map(scenarioDefinition -> new WeightedCucumberScenario(PathUtils.getAsFile(this.mapsForFeatures.get(cucumberFeature)).getName(), cucumberFeature.getName(), scenarioDefinition.getName(), this.scenarioWeightFor((Feature)cucumberFeature, (ScenarioDefinition)scenarioDefinition), this.tagsFor((Feature)cucumberFeature, (ScenarioDefinition)scenarioDefinition), this.scenarioCountFor((ScenarioDefinition)scenarioDefinition))).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not extract scenarios from %s", this.mapsForFeatures.get(cucumberFeature)), e);
            }
        };
    }

    private int scenarioCountFor(ScenarioDefinition scenarioDefinition) {
        if (scenarioDefinition instanceof ScenarioOutline) {
            return ((ScenarioOutline)scenarioDefinition).getExamples().stream().map(examples -> examples.getTableBody().size()).mapToInt(Integer::intValue).sum();
        }
        return 1;
    }

    private Set<String> tagsFor(Feature feature, ScenarioDefinition scenarioDefinition) {
        return FluentIterable.concat((Iterable)feature.getTags(), this.scenarioTags(scenarioDefinition)).stream().map(Tag::getName).collect(Collectors.toSet());
    }

    private List<Tag> scenarioTags(ScenarioDefinition scenario) {
        if (Scenario.class.isAssignableFrom(scenario.getClass())) {
            return ((Scenario)scenario).getTags();
        }
        return ((ScenarioOutline)scenario).getTags();
    }

    private BigDecimal scenarioWeightFor(Feature feature, ScenarioDefinition scenarioDefinition) {
        return this.statistics.scenarioWeightFor(feature.getName(), scenarioDefinition.getName());
    }
}

