/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import io.cucumber.core.internal.gherkin.ast.Background;
import io.cucumber.core.internal.gherkin.ast.Feature;
import io.cucumber.core.internal.gherkin.ast.Scenario;
import io.cucumber.core.internal.gherkin.ast.ScenarioDefinition;
import io.cucumber.core.internal.gherkin.ast.ScenarioOutline;
import io.cucumber.core.plugin.FeatureFileLoader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.serenitybdd.cucumber.suiteslicing.TestScenarioResult;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.thucydides.core.util.Inflector;

public class ScenarioLineCountStatistics
implements TestStatistics {
    private final List<URI> featurePaths;
    private final List<TestScenarioResult> results;

    private ScenarioLineCountStatistics(List<URI> featurePaths) {
        this.featurePaths = featurePaths;
        this.results = featurePaths.stream().map(featurePath -> new FeatureFileLoader().getFeature((URI)featurePath)).map(this.featureToScenarios()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static ScenarioLineCountStatistics fromFeaturePath(URI featurePaths) {
        return ScenarioLineCountStatistics.fromFeaturePaths(Arrays.asList(featurePaths));
    }

    public static ScenarioLineCountStatistics fromFeaturePaths(List<URI> featurePaths) {
        return new ScenarioLineCountStatistics(featurePaths);
    }

    private Function<Feature, List<TestScenarioResult>> featureToScenarios() {
        return cucumberFeature -> {
            try {
                return cucumberFeature == null ? Collections.emptyList() : cucumberFeature.getChildren().stream().filter(child -> Arrays.asList(ScenarioOutline.class, Scenario.class).contains(child.getClass())).map(this.scenarioToResult((Feature)cucumberFeature)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not extract scenarios from %s", cucumberFeature.getName()), e);
            }
        };
    }

    private Function<ScenarioDefinition, TestScenarioResult> scenarioToResult(Feature feature) {
        return scenarioDefinition -> {
            try {
                return new TestScenarioResult(feature.getName(), scenarioDefinition.getName(), this.scenarioStepCountFor(this.backgroundStepCountFor(feature), (ScenarioDefinition)scenarioDefinition));
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not determine step count for scenario '%s'", scenarioDefinition.getDescription()), e);
            }
        };
    }

    private BigDecimal scenarioStepCountFor(int backgroundStepCount, ScenarioDefinition scenarioDefinition) {
        int stepCount;
        if (scenarioDefinition instanceof ScenarioOutline) {
            ScenarioOutline outline = (ScenarioOutline)scenarioDefinition;
            Integer exampleCount = outline.getExamples().stream().map(examples -> examples.getTableBody().size()).mapToInt(Integer::intValue).sum();
            stepCount = exampleCount * (backgroundStepCount + outline.getSteps().size());
        } else {
            stepCount = backgroundStepCount + scenarioDefinition.getSteps().size();
        }
        return BigDecimal.valueOf(stepCount);
    }

    private int backgroundStepCountFor(Feature feature) {
        ScenarioDefinition scenarioDefinition = (ScenarioDefinition)feature.getChildren().get(0);
        if (scenarioDefinition instanceof Background) {
            return scenarioDefinition.getSteps().size();
        }
        return 0;
    }

    @Override
    public BigDecimal scenarioWeightFor(String feature, String scenario) {
        return this.results.stream().filter(record -> record.feature.equals(feature) && record.scenario.equals(scenario)).map(TestScenarioResult::duration).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("no result found for scenario '%s' in feature '%s'", scenario, feature)));
    }

    @Override
    public List<TestScenarioResult> records() {
        return this.results;
    }

    public String toString() {
        return Inflector.getInstance().kebabCase(this.getClass().getSimpleName(), new char[0]);
    }
}

