/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.serenitybdd.plugins.jira.domain.CustomFieldCast;
import net.serenitybdd.plugins.jira.domain.IssueComment;
import net.serenitybdd.plugins.jira.domain.RenderedView;

public class IssueSummary {
    public static final String PROJECT_KEY = "project";
    public static final String TYPE_ID_KEY = "id";
    public static final String TYPE_KEY = "issuetype";
    public static final String SUMMARY_KEY = "summary";
    public static final String DESCRIPTION_KEY = "description";
    public static final String FIELDS_KEY = "fields";
    public static final String COMMENTS_KEY = "comments";
    public static final String TRANSITIONS_KEY = "transitions";
    public static final String STATE_OPEN = "Open";
    public static final String STATE_RESOLVED = "Resolved";
    public static final String STATE_CLOSED = "Closed";
    private URI self;
    private Long id;
    private String key;
    private String summary;
    private String description;
    private String type;
    private String status;
    private List<String> labels;
    private List<String> fixVersions;
    private Map<String, Object> customFieldValues;
    private Map<String, String> renderedFieldValues;
    private String project;
    private String reporter;
    private List<IssueComment> comments;

    public IssueSummary() {
    }

    public IssueSummary(URI self, Long id, String key, String summary, String description, Map<String, String> renderedFieldValues, String type, String status) {
        this(self, id, key, summary, description, renderedFieldValues, type, status, new ArrayList<String>(), new ArrayList<String>(), new HashMap<String, Object>());
    }

    public IssueSummary(URI self, Long id, String key, String summary, String description, Map<String, String> renderedFieldValues, String type, String status, List<String> labels, List<String> fixVersions, Map<String, Object> customFields) {
        this.self = self;
        this.id = id;
        this.key = key;
        this.summary = summary;
        this.description = description;
        this.renderedFieldValues = renderedFieldValues;
        this.type = type;
        this.status = status;
        this.labels = ImmutableList.copyOf(labels);
        this.fixVersions = ImmutableList.copyOf(fixVersions);
        this.customFieldValues = ImmutableMap.copyOf(customFields);
    }

    public IssueSummary(URI self, Long id, String key, String summary, String description, Map<String, String> renderedFieldValues, String type, String status, List<String> labels, List<String> fixVersions, Map<String, Object> customFields, List<IssueComment> comments) {
        this.self = self;
        this.id = id;
        this.key = key;
        this.summary = summary;
        this.description = description;
        this.renderedFieldValues = renderedFieldValues;
        this.type = type;
        this.status = status;
        this.labels = ImmutableList.copyOf(labels);
        this.fixVersions = ImmutableList.copyOf(fixVersions);
        this.customFieldValues = ImmutableMap.copyOf(customFields);
        this.comments = ImmutableList.copyOf(comments);
    }

    public URI getSelf() {
        return this.self;
    }

    public Long getId() {
        return this.id;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public List<String> getFixVersions() {
        return this.fixVersions;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String toString() {
        return "IssueSummary{key='" + this.key + "', summary='" + this.summary + "'}";
    }

    public Optional<CustomFieldCast> customField(String fieldName) {
        if (this.customFieldValues.get(fieldName) == null) {
            return Optional.empty();
        }
        return Optional.of(new CustomFieldCast(this.customFieldValues.get(fieldName)));
    }

    public RenderedView getRendered() {
        return new RenderedView(this.renderedFieldValues);
    }

    public static IssueSummary fromJsonString(String jsonIssueRepresentation) {
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(jsonIssueRepresentation).getAsJsonObject();
        Long id = jsonObject.getAsJsonPrimitive(TYPE_ID_KEY).getAsLong();
        String key = jsonObject.getAsJsonPrimitive("key").getAsString();
        URI self = null;
        try {
            self = new URI(jsonObject.getAsJsonPrimitive("self").getAsString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        String type = null;
        if (jsonObject.get(FIELDS_KEY) != null && jsonObject.get(FIELDS_KEY).getAsJsonObject().get(TYPE_KEY) != null && jsonObject.get(FIELDS_KEY).getAsJsonObject().get(TYPE_KEY).getAsJsonObject().getAsJsonPrimitive("name") != null) {
            type = jsonObject.get(FIELDS_KEY).getAsJsonObject().get(TYPE_KEY).getAsJsonObject().getAsJsonPrimitive("name").getAsString();
        }
        return new IssueSummary(self, id, key, null, null, null, type, null);
    }
}

