/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.service;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.serenitybdd.plugins.jira.domain.IssueComment;
import net.serenitybdd.plugins.jira.domain.IssueSummary;
import net.serenitybdd.plugins.jira.domain.IssueTransition;
import net.serenitybdd.plugins.jira.model.IssueTracker;
import net.serenitybdd.plugins.jira.model.IssueTrackerUpdateException;
import net.serenitybdd.plugins.jira.service.JIRAConfiguration;
import net.serenitybdd.plugins.jira.service.JIRAConnection;
import net.serenitybdd.plugins.jira.service.NoSuchIssueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class JiraIssueTracker
implements IssueTracker {
    private final Logger logger;
    private final JIRAConnection jiraConnection;
    private final Marker warn = MarkerFactory.getMarker((String)"WARN");
    private Map<String, String> statusCodeMap = null;
    private Map<String, String> statusLabelMap = null;

    public JiraIssueTracker(JIRAConfiguration jiraConfiguration) {
        this(LoggerFactory.getLogger(JiraIssueTracker.class), jiraConfiguration);
    }

    public JiraIssueTracker(Logger logger, JIRAConfiguration jiraConfiguration) {
        this.logger = logger;
        this.jiraConnection = new JIRAConnection(jiraConfiguration);
    }

    @Override
    public JIRAConnection getJiraConnection() {
        return this.jiraConnection;
    }

    public String toString() {
        return "Connection to JIRA instance at " + this.jiraConnection.getJiraWebserviceUrl() + " with user " + this.jiraConnection.getJiraUser();
    }

    @Override
    public void addComment(String issueKey, String commentText) {
        this.jiraConnection.getRestJiraClient().addComment(issueKey, new IssueComment(commentText));
    }

    private void logJiraIssueNotFound(String issueKey) {
        this.logger.error("No JIRA issue found with key {}", (Object)issueKey);
    }

    private void processJiraException(String issueKey, IOException exception) {
        if (!this.noSuchIssue(exception)) {
            throw new IssueTrackerUpdateException("Could not update JIRA using URL (" + this.jiraConnection.getJiraWebserviceUrl() + ")", exception);
        }
        this.logger.error("No JIRA issue found with key {}", (Object)issueKey);
    }

    private boolean noSuchIssue(Exception exception) {
        return exception.toString().contains("This issue does not exist");
    }

    @Override
    public List<IssueComment> getCommentsFor(String issueKey) throws IssueTrackerUpdateException {
        try {
            return this.jiraConnection.getRestJiraClient().getComments(issueKey);
        }
        catch (ParseException pe) {
            throw new IssueTrackerUpdateException(pe.getMessage(), pe);
        }
    }

    @Override
    public void updateComment(String issuekey, IssueComment issueComment) {
        this.jiraConnection.getRestJiraClient().updateComment(issuekey, issueComment);
    }

    @Override
    public String getStatusFor(String issueKey) throws IssueTrackerUpdateException {
        Optional<IssueSummary> issue = this.jiraConnection.getRestJiraClient().loadByKey(issueKey);
        if (issue.isPresent()) {
            return issue.get().getStatus();
        }
        this.logJiraIssueNotFound(issueKey);
        throw new IssueTrackerUpdateException("Issue not found " + issueKey, new NoSuchIssueException(issueKey));
    }

    @Override
    public void doTransition(String issueKey, String workflowAction) throws IssueTrackerUpdateException {
        block4: {
            try {
                Optional<IssueSummary> issue = this.jiraConnection.getRestJiraClient().loadByKey(issueKey);
                if (issue.isPresent()) {
                    String actionId = this.getAvailableActions(issueKey).get(workflowAction.toLowerCase());
                    if (actionId != null) {
                        this.jiraConnection.getRestJiraClient().progressWorkflowTransition(issueKey, actionId);
                    }
                    break block4;
                }
                this.logJiraIssueNotFound(issueKey);
                throw new IssueTrackerUpdateException("Issue not found " + issueKey, new NoSuchIssueException(issueKey));
            }
            catch (ParseException pe) {
                throw new IssueTrackerUpdateException(pe.getMessage(), pe);
            }
        }
    }

    private Map<String, String> getAvailableActions(String issueKey) throws ParseException {
        HashMap<String, String> availableActionMap = new HashMap<String, String>();
        List<IssueTransition> actions = this.jiraConnection.getRestJiraClient().getAvailableTransitions(issueKey);
        for (IssueTransition action : actions) {
            availableActionMap.put(action.getName().toLowerCase(), action.getId());
        }
        return availableActionMap;
    }
}

