/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestResultList;

public class TestResultTally<T> {
    private final ConcurrentMap<String, List<T>> testOutcomesTally = Maps.newConcurrentMap();

    public synchronized void recordResult(String issueNumber, T outcome) {
        this.getTestOutcomeListForIssue(issueNumber).add(outcome);
    }

    public List<T> getTestOutcomesForIssue(String issueNumber) {
        return ImmutableList.copyOf(this.getTestOutcomeListForIssue(issueNumber));
    }

    protected List<T> getTestOutcomeListForIssue(String issueNumber) {
        List resultTallyForIssue = (List)this.testOutcomesTally.get(issueNumber);
        if (resultTallyForIssue == null) {
            this.testOutcomesTally.putIfAbsent(issueNumber, new Vector());
        }
        return (List)this.testOutcomesTally.get(issueNumber);
    }

    public TestResult getResultForIssue(String issueNumber) {
        List testOutcomesForThisIssue = (List)this.testOutcomesTally.get(issueNumber);
        if (testOutcomesForThisIssue.stream().allMatch(TestOutcome.class::isInstance)) {
            List testOutcomes = (List)this.testOutcomesTally.get(issueNumber);
            List results = testOutcomes.stream().map(TestOutcome::getResult).collect(Collectors.toList());
            return TestResultList.overallResultFrom(results);
        }
        return TestResultList.overallResultFrom(new ArrayList());
    }

    public Set<String> getIssues() {
        return this.testOutcomesTally.keySet();
    }
}

