/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.service;

import net.serenitybdd.plugins.jira.client.JerseyJiraClient;
import net.serenitybdd.plugins.jira.service.JIRAConfiguration;
import net.serenitybdd.plugins.jira.service.JIRAInfrastructure;

public class JIRAConnection {
    private final JIRAConfiguration configuration;
    private final JerseyJiraClient jiraClient;

    public JIRAConnection() {
        this(JIRAInfrastructure.getConfiguration());
    }

    public JIRAConnection(JIRAConfiguration configuration) {
        this.configuration = configuration;
        this.jiraClient = new JerseyJiraClient(configuration.getJiraWebserviceUrl(), configuration.getJiraUser(), configuration.getJiraPassword(), configuration.getProject());
    }

    public JerseyJiraClient getRestJiraClient() {
        return this.jiraClient;
    }

    protected JIRAConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getJiraUser() {
        return this.getConfiguration().getJiraUser();
    }

    public String getJiraPassword() {
        return this.getConfiguration().getJiraPassword();
    }

    public String getJiraWebserviceUrl() {
        return this.getConfiguration().getJiraWebserviceUrl();
    }

    public String getProject() {
        return this.getConfiguration().getProject();
    }

    public void logout() {
    }
}

