/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.service;

import java.io.IOException;
import net.serenitybdd.core.di.SerenityInfrastructure;
import net.serenitybdd.plugins.jira.service.JIRAConfiguration;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.util.PropertiesLocalPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertiesJIRAConfiguration
implements JIRAConfiguration {
    private final EnvironmentVariables environmentVariables;
    public static final String JIRA_URL = "jira.url";
    public static final String JIRA_PROJECT = "jira.project";
    public static final String JIRA_USERNAME = "jira.username";
    public static final String JIRA_PASSWORD = "jira.password";
    public static final String JIRA_WIKI_RENDERER = "jira.wiki.renderer";
    private final Logger logger = LoggerFactory.getLogger(SystemPropertiesJIRAConfiguration.class);

    public SystemPropertiesJIRAConfiguration() {
        this(SerenityInfrastructure.getEnvironmentVariables());
    }

    public SystemPropertiesJIRAConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.updateEnvironmentVariablesFromPropertiesFiles(environmentVariables);
    }

    private void updateEnvironmentVariablesFromPropertiesFiles(EnvironmentVariables environmentVariables) {
        PropertiesLocalPreferences localPreferences = new PropertiesLocalPreferences(environmentVariables);
        try {
            localPreferences.loadPreferences();
        }
        catch (IOException e) {
            this.logger.warn("Failed to load JIRA preferences from thucydides.properties file", (Throwable)e);
        }
    }

    @Override
    public String getJiraUser() {
        return this.getEnvironmentOrSystemProperty(JIRA_USERNAME);
    }

    private String getEnvironmentOrSystemProperty(String field) {
        return this.getEnvironmentOrSystemProperty(field, null);
    }

    private String getEnvironmentOrSystemProperty(String field, String defaultValue) {
        if (this.environmentVariables.getProperty(field) != null) {
            return this.environmentVariables.getProperty(field);
        }
        if (this.environmentVariables.getValue(field) != null) {
            return this.environmentVariables.getValue(field);
        }
        return this.environmentVariables.getValue(field);
    }

    @Override
    public String getJiraPassword() {
        return this.getEnvironmentOrSystemProperty(JIRA_PASSWORD);
    }

    @Override
    public boolean isWikiRenderedActive() {
        return this.environmentVariables.getPropertyAsBoolean(JIRA_WIKI_RENDERER, true);
    }

    @Override
    public String getProject() {
        return this.getEnvironmentOrSystemProperty(JIRA_PROJECT);
    }

    @Override
    public String getJiraWebserviceUrl() {
        return this.environmentVariables.getProperty(JIRA_URL);
    }

    @Override
    public String getJiraUrl() {
        return this.environmentVariables.getProperty(JIRA_URL);
    }
}

