/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.junit5.JUnit5Tags;
import net.serenitybdd.junit5.PendingTestException;
import net.serenitybdd.junit5.SkippedTestException;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.launcher.TestIdentifier;

public class SerenityJUnit5Extension
implements TestInstancePostProcessor,
AfterEachCallback,
BeforeEachCallback {
    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) {
        Serenity.injectDriverInto((Object)testInstance);
        Serenity.injectAnnotatedPagesObjectInto((Object)testInstance);
        Serenity.injectScenarioStepsInto((Object)testInstance);
        Serenity.injectDependenciesInto((Object)testInstance);
    }

    public void afterEach(ExtensionContext context) {
        if (!StepEventBus.getEventBus().isBaseStepListenerRegistered()) {
            System.out.println("NO BASE STEP LISTENER FOUND IN THREAD " + Thread.currentThread());
        }
        TestOutcome outcome = StepEventBus.getEventBus().getBaseStepListener().getCurrentTestOutcome();
        String methodName = outcome.getQualifiedMethodName();
        context.getTestMethod().ifPresent(method -> {
            if (method.getName().equals(methodName)) {
                if (outcome.getTestFailureCause() != null) {
                    throw outcome.getTestFailureCause().asRuntimeException();
                }
                if (outcome.isPending().booleanValue()) {
                    throw new PendingTestException(context.getDisplayName());
                }
                if (outcome.isSkipped().booleanValue()) {
                    throw new SkippedTestException(context.getDisplayName());
                }
            }
        });
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        context.getTestMethod().ifPresent(method -> {
            BaseStepListener baseStepListener = StepEventBus.getEventBus().getBaseStepListener();
            baseStepListener.addTagsToCurrentStory(JUnit5Tags.forMethod(method));
        });
    }

    private void configureTagsFor(TestIdentifier serenityTest) {
        Set testTags = serenityTest.getTags();
        List tags = testTags.stream().map(tag -> TestTag.withValue((String)tag.getName())).collect(Collectors.toList());
        StepEventBus.getEventBus().getBaseStepListener().addTagsToCurrentStory(tags);
    }
}

