/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.navigator;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.serenitybdd.reports.io.ReportIOKt;
import net.serenitybdd.reports.navigator.GenerateReport;
import net.serenitybdd.reports.navigator.GenerateReportKt;
import net.thucydides.core.reports.ExtendedReport;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnet/serenitybdd/reports/navigator/GenerateReport;", "Lnet/thucydides/core/reports/ExtendedReport;", "()V", "environmentVariables", "Lnet/thucydides/model/util/EnvironmentVariables;", "sourceDirectory", "Ljava/nio/file/Path;", "outputDirectory", "(Lnet/thucydides/model/util/EnvironmentVariables;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "getEnvironmentVariables", "()Lnet/thucydides/model/util/EnvironmentVariables;", "copyAllOtherNavigatorResources", "", "templateDir", "copyToOutputDirectory", "Ljava/util/function/Consumer;", "extractArchive", "outputDir", "fillTemplateAndWriteToReportDirectory", "templateDirectory", "generateReport", "getDescription", "", "getName", "setOutputDirectory", "setSourceDirectory", "Companion", "serenity-navigator-report"})
@SourceDebugExtension(value={"SMAP\nGenerateReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateReport.kt\nnet/serenitybdd/reports/navigator/GenerateReport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1549#2:161\n1620#2,3:162\n1#3:165\n*S KotlinDebug\n*F\n+ 1 GenerateReport.kt\nnet/serenitybdd/reports/navigator/GenerateReport\n*L\n104#1:161\n104#1:162,3\n*E\n"})
public final class GenerateReport
implements ExtendedReport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnvironmentVariables environmentVariables;
    @NotNull
    private Path sourceDirectory;
    @NotNull
    private Path outputDirectory;
    @NotNull
    private static final Log logging;

    public GenerateReport(@NotNull EnvironmentVariables environmentVariables, @NotNull Path sourceDirectory, @NotNull Path outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)environmentVariables, (String)"environmentVariables");
        Intrinsics.checkNotNullParameter((Object)sourceDirectory, (String)"sourceDirectory");
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        this.environmentVariables = environmentVariables;
        this.sourceDirectory = sourceDirectory;
        this.outputDirectory = outputDirectory;
    }

    public /* synthetic */ GenerateReport(EnvironmentVariables environmentVariables, Path path, Path path2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = GenerateReportKt.sourceDirectoryDefinedIn(environmentVariables);
        }
        if ((n & 4) != 0) {
            path2 = GenerateReportKt.outputDirectoryDefinedIn(environmentVariables);
        }
        this(environmentVariables, path, path2);
    }

    @NotNull
    public final EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public GenerateReport() {
        EnvironmentVariables environmentVariables = ModelInfrastructure.getEnvironmentVariables();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariables, (String)"getEnvironmentVariables(...)");
        this(environmentVariables, null, null, 6, null);
    }

    @NotNull
    public String getName() {
        return "navigator";
    }

    @NotNull
    public String getDescription() {
        return "Full Report As React Based Single Page Application";
    }

    public void setSourceDirectory(@NotNull Path sourceDirectory) {
        Intrinsics.checkNotNullParameter((Object)sourceDirectory, (String)"sourceDirectory");
        this.sourceDirectory = sourceDirectory;
    }

    public void setOutputDirectory(@NotNull Path outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        this.outputDirectory = outputDirectory;
    }

    @NotNull
    public Path generateReport() {
        Path tmpDir = Files.createTempDirectory("serenity", new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)tmpDir);
        this.extractArchive(tmpDir);
        this.fillTemplateAndWriteToReportDirectory(tmpDir);
        this.copyAllOtherNavigatorResources(tmpDir);
        File file = tmpDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        if (!FilesKt.deleteRecursively((File)file)) {
            logging.error((Object)("could not delete " + tmpDir));
        }
        String[] stringArray = new String[]{"index.html"};
        Path path = this.outputDirectory.resolve(Paths.get("navigator", stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final void copyAllOtherNavigatorResources(Path templateDir) {
        Files.walk(templateDir, Integer.MAX_VALUE, new FileVisitOption[0]).filter(arg_0 -> GenerateReport.copyAllOtherNavigatorResources$lambda$0((Function1)new Function1<Path, Boolean>(templateDir){
            final /* synthetic */ Path $templateDir;
            {
                this.$templateDir = $templateDir;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Path it) {
                return !Intrinsics.areEqual((Object)it, (Object)this.$templateDir);
            }
        }, arg_0)).filter(arg_0 -> GenerateReport.copyAllOtherNavigatorResources$lambda$1(copyAllOtherNavigatorResources.2.INSTANCE, arg_0)).forEach(this.copyToOutputDirectory(templateDir));
    }

    private final Consumer<Path> copyToOutputDirectory(Path templateDir) {
        return arg_0 -> GenerateReport.copyToOutputDirectory$lambda$2(this, templateDir, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private final void fillTemplateAndWriteToReportDirectory(Path templateDirectory) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Path indexHtml = templateDirectory.resolve("index.html");
        List lines = Files.lines(indexHtml).collect(Collectors.toList());
        Intrinsics.checkNotNull(lines);
        if (((Collection)lines).size() > 1) {
            throw new RuntimeException("template index.html is supposed to be a minified into a single line");
        }
        String content = (String)lines.get(0);
        Intrinsics.checkNotNull((Object)content);
        String[] stringArray = new String[]{"<script type=\"text/javascript\"></script>"};
        List split = StringsKt.split$default((CharSequence)content, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Path navigatorRoot = this.outputDirectory.resolve("navigator");
        navigatorRoot.toFile().mkdirs();
        FileWriter writer = new FileWriter(navigatorRoot.resolve("index.html").toFile());
        writer.write((String)split.get(0));
        writer.write("<script type=\"text/javascript\">window.outcomes=[");
        TestOutcomes testOutcomes = ReportIOKt.testOutcomesIn((Path)this.sourceDirectory);
        List list = testOutcomes.getOutcomes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOutcomes(...)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var11_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TestOutcome testOutcome = (TestOutcome)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toJson());
        }
        String it = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        writer.write(it);
        writer.write("];</script>");
        writer.write((String)split.get(1));
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void extractArchive(Path outputDir) {
        try {
            TarArchiveInputStream i = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(this.getClass().getResourceAsStream("serenity-report-navigator_v0.2.9.tar.gz"))));
            TarArchiveEntry entry = null;
            while ((entry = (TarArchiveEntry)i.getNextEntry()) != null) {
                if (!i.canReadEntryData((ArchiveEntry)entry)) {
                    logging.error((Object)("can't read " + entry.getName()));
                    continue;
                }
                String name = ((Object)outputDir.toAbsolutePath().resolve(entry.getName())).toString();
                File f = new File(name);
                if (entry.isDirectory()) {
                    if (f.isDirectory() || f.mkdirs()) continue;
                    throw new IOException("failed to create directory " + f);
                }
                File parent = f.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("failed to create directory " + parent);
                }
                Closeable closeable = Files.newOutputStream(f.toPath(), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    OutputStream o = (OutputStream)closeable;
                    boolean bl = false;
                    int n = IOUtils.copy((InputStream)((InputStream)i), (OutputStream)o);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final boolean copyAllOtherNavigatorResources$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean copyAllOtherNavigatorResources$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void copyToOutputDirectory$lambda$2(GenerateReport this$0, Path $templateDir, Path it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$templateDir, (String)"$templateDir");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path navigatorRoot = this$0.outputDirectory.resolve("navigator");
        Path outputPath = navigatorRoot.resolve($templateDir.relativize(it));
        if (it.toFile().isDirectory()) {
            outputPath.toFile().mkdirs();
        }
        if (it.toFile().isFile()) {
            IOUtils.copy((InputStream)Files.newInputStream(it, new OpenOption[0]), (OutputStream)Files.newOutputStream(outputPath, new OpenOption[0]));
        }
    }

    static {
        Log log = LogFactory.getLog(GenerateReport.class);
        Intrinsics.checkNotNullExpressionValue((Object)log, (String)"getLog(...)");
        logging = log;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/serenitybdd/reports/navigator/GenerateReport$Companion;", "", "()V", "logging", "Lorg/apache/commons/logging/Log;", "getLogging", "()Lorg/apache/commons/logging/Log;", "serenity-navigator-report"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Log getLogging() {
            return logging;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

