/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.saucelabs;

import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.webdriver.RemoteDriver;
import net.serenitybdd.core.webdriver.enhancers.AfterAWebdriverScenario;
import net.serenitybdd.saucelabs.SauceLabsTestSession;
import net.thucydides.core.model.ExternalLink;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfterASauceLabsScenario
implements AfterAWebdriverScenario {
    private static final Logger LOGGER = LoggerFactory.getLogger(AfterASauceLabsScenario.class);

    public void apply(EnvironmentVariables environmentVariables, TestOutcome testOutcome, WebDriver driver) {
        if (driver == null || !RemoteDriver.isARemoteDriver((WebDriver)driver)) {
            return;
        }
        String sessionId = RemoteDriver.of((WebDriver)driver).getSessionId().toString();
        String userName = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{"saucelabs.username"}).orElse(null);
        String key = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{"saucelabs.accessKey"}).orElse(null);
        if (userName == null || key == null) {
            LOGGER.warn("Incomplete SauceLabs configuration" + System.lineSeparator() + "SauceLabs integration needs the following system properties to work:" + System.lineSeparator() + "  - saucelabs.username - Your SauceLabs account name" + System.lineSeparator() + "  - saucelabs.accessKey - Your SauceLabs Access Key" + System.lineSeparator() + "You can find both of these here: https://app.saucelabs.com/user-settings");
        } else {
            SauceLabsTestSession sauceLabsTestSession = new SauceLabsTestSession(userName, key, sessionId);
            sauceLabsTestSession.updateTestResultFor(testOutcome);
            String publicUrl = sauceLabsTestSession.getTestLink();
            testOutcome.setLink(new ExternalLink(publicUrl, "SauceLabs"));
        }
    }

    public boolean isActivated(EnvironmentVariables environmentVariables) {
        return EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{"saucelabs.platformName"}).isPresent();
    }
}

