/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.saucelabs;

import io.restassured.RestAssured;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SauceLabsTestSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(SauceLabsTestSession.class);
    private static final String REST_API_URL = "https://%s:%s@saucelabs.com/rest/v1/%s/jobs/%s";
    private static final String APP_TEST_LINK_TEMPLATE = "https://app.saucelabs.com/tests/%s";
    private final String sauceLabsUsername;
    private final String sauceLabsKey;
    private final String sessionId;

    public SauceLabsTestSession(String sauceLabsUsername, String sauceLabsKey, String sessionId) {
        this.sauceLabsUsername = sauceLabsUsername;
        this.sauceLabsKey = sauceLabsKey;
        this.sessionId = sessionId;
    }

    public void updateTestResultFor(final TestOutcome testOutcome) {
        HashMap<Object, Object> requestBody = new HashMap<Object, Object>(){
            {
                this.put("passed", SauceLabsTestSession.this.testPassed(testOutcome));
                this.put("error", testOutcome.getErrorMessage());
            }
        };
        RestAssured.given().contentType("application/json").body((Object)requestBody).put(this.getRESTAPIUri());
    }

    public String getTestLink() {
        if (this.sauceLabsKey != null) {
            return this.noLoginLink();
        }
        return String.format(APP_TEST_LINK_TEMPLATE, this.sessionId);
    }

    private boolean testPassed(TestOutcome outcome) {
        return this.latestResultOf(outcome) == TestResult.SUCCESS;
    }

    private URI getRESTAPIUri() {
        URI uri = null;
        try {
            uri = new URI(String.format(REST_API_URL, this.sauceLabsUsername, this.sauceLabsKey, this.sauceLabsUsername, this.sessionId));
        }
        catch (URISyntaxException e) {
            LOGGER.error("Failed to parse SauceLabs API url.", (Throwable)e);
        }
        return uri;
    }

    private TestResult latestResultOf(TestOutcome outcome) {
        if (outcome.isDataDriven()) {
            return ((TestStep)outcome.getLatestTopLevelTestStep().get()).getResult();
        }
        return outcome.getResult();
    }

    private String noLoginLink() {
        String authCode = this.generateHMACFor(this.sauceLabsUsername + ":" + this.sauceLabsKey, this.sessionId);
        return String.format(APP_TEST_LINK_TEMPLATE, this.sessionId) + "?auth=" + authCode;
    }

    private String generateHMACFor(String secretKey, String message) {
        try {
            byte[] keyBytes = secretKey.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec key = new SecretKeySpec(keyBytes, 0, keyBytes.length, "HmacMD5");
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(key);
            return new String(Hex.encodeHex((byte[])mac.doFinal(message.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Could not generate HMAC for some reason", e);
        }
    }
}

