/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.saucelabs;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.RemoteTestName;
import net.thucydides.core.webdriver.capabilities.W3CCapabilities;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SaucelabsRemoteDriverCapabilities {
    private final EnvironmentVariables environmentVariables;
    private static final Map<String, String> SAUCELABS_BROWSER_NAMES = new HashMap<String, String>(){
        {
            this.put("iexplorer", "internet explorer");
            this.put("edge", "MicrosoftEdge");
        }
    };

    public SaucelabsRemoteDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public MutableCapabilities getCapabilities(MutableCapabilities capabilities) {
        MutableCapabilities saucelabsCapabilities = this.saucelabsCapabilitiesDefinedIn(this.environmentVariables);
        DesiredCapabilities w3cCapabilitiesInSaucelabsSection = W3CCapabilities.definedIn((EnvironmentVariables)this.environmentVariables).withPrefix("saucelabs");
        this.configureBrowserAndPlatformIfDefinedInSaucelabsBlock((MutableCapabilities)w3cCapabilitiesInSaucelabsSection, capabilities);
        this.addBuildNumberTo(saucelabsCapabilities);
        this.configureTestName(saucelabsCapabilities);
        capabilities.setCapability("sauce:options", (Object)saucelabsCapabilities);
        return capabilities;
    }

    private MutableCapabilities saucelabsCapabilitiesDefinedIn(EnvironmentVariables environmentVariables) {
        Properties saucelabsProperties = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getPropertiesWithPrefix("saucelabs.");
        MutableCapabilities sauceCaps = new MutableCapabilities();
        for (String propertyName : saucelabsProperties.stringPropertyNames()) {
            String unprefixedPropertyName = this.unprefixed(propertyName);
            sauceCaps.setCapability(unprefixedPropertyName, saucelabsProperties.getProperty(propertyName));
        }
        return sauceCaps;
    }

    private void addBuildNumberTo(MutableCapabilities capabilities) {
        if (this.environmentVariables.getProperty("BUILD_NUMBER") != null) {
            capabilities.setCapability("build", this.environmentVariables.getProperty("BUILD_NUMBER"));
        }
    }

    private void configureBrowserAndPlatformIfDefinedInSaucelabsBlock(MutableCapabilities sourceCapabilities, MutableCapabilities capabilities) {
        if (sourceCapabilities.getBrowserName() != null) {
            String browserName = sourceCapabilities.getBrowserName();
            capabilities.setCapability("browserName", SAUCELABS_BROWSER_NAMES.getOrDefault(browserName, browserName));
        }
        if (sourceCapabilities.getVersion() != null) {
            capabilities.setCapability("browserVersion", sourceCapabilities.getVersion());
        }
        if (sourceCapabilities.getCapability("platformName") != null) {
            capabilities.setCapability("platformName", sourceCapabilities.getCapability("platformName"));
        }
    }

    private void configureTestName(MutableCapabilities capabilities) {
        String testName = ThucydidesSystemProperty.SAUCELABS_TEST_NAME.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)testName)) {
            capabilities.setCapability("name", testName);
        } else {
            Optional latestOutcome = StepEventBus.getEventBus().getBaseStepListener().latestTestOutcome();
            Optional guessedTestName = latestOutcome.map(testOutcome -> Optional.of(testOutcome.getStoryTitle() + ": " + testOutcome.getTitle())).orElseGet(RemoteTestName::fromCurrentTest);
            guessedTestName.ifPresent(name -> capabilities.setCapability("name", name));
        }
    }

    private String unprefixed(String propertyName) {
        return propertyName.replace("saucelabs.", "");
    }
}

