/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.questions.EnumValues;
import net.serenitybdd.screenplay.questions.converters.BooleanConverter;
import net.serenitybdd.screenplay.questions.converters.Converter;
import net.serenitybdd.screenplay.questions.converters.DateTimeConverter;
import net.serenitybdd.screenplay.questions.converters.DoubleConverter;
import net.serenitybdd.screenplay.questions.converters.FloatConverter;
import net.serenitybdd.screenplay.questions.converters.IntegerConverter;
import net.serenitybdd.screenplay.questions.converters.LongConverter;
import net.serenitybdd.screenplay.questions.converters.StringConverter;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class UIState<T> {
    protected final Actor actor;
    protected Map<Class<?>, Converter> DEFAULT_CONVERTERS = Maps.newHashMap();

    protected UIState(Actor actor) {
        this.DEFAULT_CONVERTERS.put(Boolean.class, new BooleanConverter());
        this.DEFAULT_CONVERTERS.put(DateTime.class, new DateTimeConverter());
        this.DEFAULT_CONVERTERS.put(Double.class, new DoubleConverter());
        this.DEFAULT_CONVERTERS.put(Float.class, new FloatConverter());
        this.DEFAULT_CONVERTERS.put(Integer.class, new IntegerConverter());
        this.DEFAULT_CONVERTERS.put(String.class, new StringConverter());
        this.DEFAULT_CONVERTERS.put(Long.class, new LongConverter());
        this.actor = actor;
    }

    public abstract T resolve();

    public T value() {
        return this.resolve();
    }

    public <TARGET> TARGET as(Class<TARGET> type) {
        return (TARGET)this.converterFor(type).convert(this.resolve());
    }

    public String asString() {
        return this.as(String.class);
    }

    public Integer asInteger() {
        return this.as(Integer.class);
    }

    public Double asDouble() {
        return this.as(Double.class);
    }

    public Boolean asBoolean() {
        return this.as(Boolean.class);
    }

    public DateTime asDate() {
        return this.as(DateTime.class);
    }

    public DateTime asDate(String format) {
        return DateTime.parse((String)this.resolve().toString(), (DateTimeFormatter)DateTimeFormat.forPattern((String)format));
    }

    public <T> T asEnum(Class<T> enumType) {
        String value = this.resolve().toString();
        return EnumValues.forType(enumType).getValueOf(value);
    }

    protected <T> List<T> convertToEnums(Class<T> enumType, List<?> values) {
        return EnumValues.forType(enumType).getValuesOf(values);
    }

    protected Converter converterFor(Class<?> type) {
        Preconditions.checkState((boolean)this.DEFAULT_CONVERTERS.containsKey(type), (Object)("No converter found for " + type));
        return this.DEFAULT_CONVERTERS.get(type);
    }
}

