/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actions;

import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.Tasks;
import net.serenitybdd.screenplay.actions.SelectStrategy;
import net.serenitybdd.screenplay.actions.selectactions.SelectByIndexFromBy;
import net.serenitybdd.screenplay.actions.selectactions.SelectByIndexFromElement;
import net.serenitybdd.screenplay.actions.selectactions.SelectByIndexFromTarget;
import net.serenitybdd.screenplay.actions.selectactions.SelectByValueFromBy;
import net.serenitybdd.screenplay.actions.selectactions.SelectByValueFromElement;
import net.serenitybdd.screenplay.actions.selectactions.SelectByValueFromTarget;
import net.serenitybdd.screenplay.actions.selectactions.SelectByVisibleTextFromBy;
import net.serenitybdd.screenplay.actions.selectactions.SelectByVisibleTextFromElement;
import net.serenitybdd.screenplay.actions.selectactions.SelectByVisibleTextFromTarget;
import net.serenitybdd.screenplay.targets.Target;
import org.openqa.selenium.By;

public class SelectFromOptions {
    private final SelectStrategy strategy;
    private String theText;
    private Integer indexValue;

    public SelectFromOptions(SelectStrategy strategy) {
        this.strategy = strategy;
    }

    public static SelectFromOptions byValue(String value) {
        SelectFromOptions selectFromOptions = new SelectFromOptions(SelectStrategy.ByValue);
        selectFromOptions.theText = value;
        return selectFromOptions;
    }

    public static SelectFromOptions byVisibleText(String value) {
        SelectFromOptions selectFromOptions = new SelectFromOptions(SelectStrategy.ByVisibleText);
        selectFromOptions.theText = value;
        return selectFromOptions;
    }

    public static SelectFromOptions byIndex(Integer indexValue) {
        SelectFromOptions selectFromOptions = new SelectFromOptions(SelectStrategy.ByIndex);
        selectFromOptions.indexValue = indexValue;
        return selectFromOptions;
    }

    public Performable from(String cssOrXpathForElement) {
        return this.from(Target.the(cssOrXpathForElement).locatedBy(cssOrXpathForElement));
    }

    public Performable from(Target target) {
        switch (this.strategy) {
            case ByValue: {
                return Tasks.instrumented(SelectByValueFromTarget.class, (Object[])new Object[]{target, this.theText});
            }
            case ByVisibleText: {
                return Tasks.instrumented(SelectByVisibleTextFromTarget.class, (Object[])new Object[]{target, this.theText});
            }
            case ByIndex: {
                return Tasks.instrumented(SelectByIndexFromTarget.class, (Object[])new Object[]{target, this.indexValue});
            }
        }
        throw new IllegalStateException("Unknown select strategy " + (Object)((Object)this.strategy));
    }

    public Performable from(WebElementFacade element) {
        switch (this.strategy) {
            case ByValue: {
                return Tasks.instrumented(SelectByValueFromElement.class, (Object[])new Object[]{element, this.theText});
            }
            case ByVisibleText: {
                return Tasks.instrumented(SelectByVisibleTextFromElement.class, (Object[])new Object[]{element, this.theText});
            }
            case ByIndex: {
                return Tasks.instrumented(SelectByIndexFromElement.class, (Object[])new Object[]{element, this.indexValue});
            }
        }
        throw new IllegalStateException("Unknown select strategy " + (Object)((Object)this.strategy));
    }

    public Performable from(By ... locators) {
        switch (this.strategy) {
            case ByValue: {
                return Tasks.instrumented(SelectByValueFromBy.class, (Object[])new Object[]{this.theText, locators});
            }
            case ByVisibleText: {
                return Tasks.instrumented(SelectByVisibleTextFromBy.class, (Object[])new Object[]{this.theText, locators});
            }
            case ByIndex: {
                return Tasks.instrumented(SelectByIndexFromBy.class, (Object[])new Object[]{this.indexValue, locators});
            }
        }
        throw new IllegalStateException("Unknown select strategy " + (Object)((Object)this.strategy));
    }
}

