/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.selectors.Selectors;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.targets.TargetSelectorWithVariables;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.exceptions.ElementNotFoundAfterTimeoutError;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class MultiXPathOrCssTarget
extends SearchableTarget {
    private final String[] cssOrXPathSelectors;

    public MultiXPathOrCssTarget(String targetElementName, Optional<IFrame> iFrame, Optional<Duration> timeout, String ... cssOrXPathSelectors) {
        super(targetElementName, iFrame, timeout);
        this.cssOrXPathSelectors = cssOrXPathSelectors;
    }

    @Override
    public WebElementFacade resolveFor(PageObject page) {
        Duration effectiveTimeout = this.timeout.orElse(page.getImplicitWaitTimeout());
        Optional<WebElementFacade> resolvedElement = this.findFirstMatching(page, this.cssOrXPathSelectors);
        if (resolvedElement.isPresent()) {
            return resolvedElement.get();
        }
        long maxTimeAllowed = effectiveTimeout.toMillis();
        long timeStarted = System.currentTimeMillis();
        while (System.currentTimeMillis() - timeStarted < maxTimeAllowed) {
            resolvedElement = this.findFirstMatching(page, this.cssOrXPathSelectors);
            if (!resolvedElement.isPresent()) continue;
            return resolvedElement.get();
        }
        StepEventBus.getEventBus().notifyFailure();
        throw new ElementNotFoundAfterTimeoutError("No element was found after " + effectiveTimeout.toMillis() / 1000L + "s for " + this.getName() + System.lineSeparator() + "We tried with the following locators: " + Arrays.toString(this.cssOrXPathSelectors));
    }

    private Optional<WebElementFacade> findFirstMatching(PageObject page, String ... cssOrXPathSelectors) {
        for (String selector : cssOrXPathSelectors) {
            List matchingElements = page.withTimeoutOf(Duration.ZERO).findAll(selector);
            if (matchingElements.isEmpty()) continue;
            return Optional.of(matchingElements.get(0));
        }
        return Optional.empty();
    }

    private List<WebElementFacade> findAllMatching(PageObject page, String ... cssOrXPathSelectors) {
        for (String selector : cssOrXPathSelectors) {
            List matchingElements = page.withTimeoutOf(Duration.ZERO).findAll(selector);
            if (matchingElements.isEmpty()) continue;
            return matchingElements;
        }
        return new ArrayList<WebElementFacade>();
    }

    @Override
    public List<WebElementFacade> resolveAllFor(PageObject page) {
        List<WebElementFacade> resolvedElements = this.findAllMatching(page, this.cssOrXPathSelectors);
        if (this.timeout.isPresent()) {
            if (resolvedElements.isEmpty()) {
                return resolvedElements;
            }
            Duration effectiveTimeout = this.timeout.orElse(page.getImplicitWaitTimeout());
            long maxTimeAllowed = effectiveTimeout.toMillis();
            long timeStarted = System.currentTimeMillis();
            while (System.currentTimeMillis() - timeStarted < maxTimeAllowed) {
                resolvedElements = this.findAllMatching(page, this.cssOrXPathSelectors);
                if (resolvedElements.isEmpty()) continue;
                return resolvedElements;
            }
        }
        return resolvedElements;
    }

    @Override
    public SearchableTarget of(String ... parameters) {
        List<String> instantiatedLocators = Arrays.stream(this.cssOrXPathSelectors).map(locator -> this.instantiated((String)locator, parameters)).collect(Collectors.toList());
        return new MultiXPathOrCssTarget(this.instantiated(this.targetElementName, parameters), this.iFrame, this.timeout, instantiatedLocators.toArray(new String[0]));
    }

    @Override
    public String getCssOrXPathSelector() {
        throw new UnsupportedOperationException("The getCssOrXPathSelector() method is not supported for multi-locator Targets");
    }

    @Override
    public Target called(String name) {
        return new MultiXPathOrCssTarget(name, this.iFrame, this.timeout, this.cssOrXPathSelectors);
    }

    @Override
    public Target waitingForNoMoreThan(Duration timeout) {
        return new MultiXPathOrCssTarget(this.targetElementName, this.iFrame, Optional.ofNullable(timeout), this.cssOrXPathSelectors);
    }

    @Override
    public List<By> selectors(WebDriver driver) {
        return Arrays.stream(this.cssOrXPathSelectors).map(Selectors::xpathOrCssSelector).collect(Collectors.toList());
    }

    @Override
    public List<String> getCssOrXPathSelectors() {
        return Arrays.asList(this.cssOrXPathSelectors);
    }

    private String instantiated(String cssOrXPathSelector, String[] parameters) {
        return new TargetSelectorWithVariables(cssOrXPathSelector).resolvedWith(parameters);
    }
}

