/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.waits;

import java.time.Duration;
import net.serenitybdd.core.pages.WebElementState;
import net.serenitybdd.markers.IsSilent;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.EventualConsequence;
import net.serenitybdd.screenplay.GivenWhenThen;
import net.serenitybdd.screenplay.Interaction;
import net.serenitybdd.screenplay.SilentInteraction;
import net.serenitybdd.screenplay.questions.WebElementQuestion;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.waits.WaitUntilBuilder;
import org.hamcrest.Matcher;

public class WaitUntilTargetIsReady
implements Interaction,
IsSilent {
    private final Target target;
    private final Matcher<WebElementState> expectedState;

    public WaitUntilTargetIsReady(Target target, Matcher<WebElementState> expectedState) {
        this.target = target;
        this.expectedState = expectedState;
    }

    public <A extends Actor> void performAs(A actor) {
        actor.should(new Consequence[]{EventualConsequence.eventually((Consequence)GivenWhenThen.seeThat(WebElementQuestion.the(this.target), this.expectedState)).withNoReporting()});
    }

    public WaitUntilBuilder forNoMoreThan(long amount) {
        return new WaitUntilBuilder(amount, this.target, this.expectedState);
    }

    public Interaction forNoMoreThan(final Duration amount) {
        return new SilentInteraction(){

            public <T extends Actor> void performAs(T actor) {
                actor.should(new Consequence[]{GivenWhenThen.seeThat(WebElementQuestion.the(WaitUntilTargetIsReady.this.target.waitingForNoMoreThan(amount)), WaitUntilTargetIsReady.this.expectedState)});
            }
        };
    }
}

