/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenshots.shutterbug;

import com.assertthat.selenium_shutterbug.core.Capture;
import com.assertthat.selenium_shutterbug.core.PageSnapshot;
import com.assertthat.selenium_shutterbug.core.Shutterbug;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.serenitybdd.core.photography.PhotoLens;
import net.serenitybdd.core.photography.ScreenShooter;
import net.serenitybdd.core.photography.WebDriverPhotoLens;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.WebDriver;

public class Shutterbug1XScreenShooter
implements ScreenShooter {
    private final WebDriver driver;
    private final EnvironmentVariables environmentVariables;

    public Shutterbug1XScreenShooter(PhotoLens lens) {
        this.driver = ((WebDriverPhotoLens)lens).getDriver();
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
    }

    public byte[] takeScreenshot() throws IOException {
        int betweenScrollTimeout = Integer.parseInt(this.environmentVariables.getValue("shutterbug.betweenScrollTimeout", "100"));
        boolean useDevicePixelRatio = Boolean.parseBoolean(this.environmentVariables.getValue("shutterbug.useDevicePixelRatio", "true"));
        PageSnapshot snapshot = Shutterbug.shootPage((WebDriver)this.driver, (Capture)this.captureStrategy(), (int)betweenScrollTimeout, (boolean)useDevicePixelRatio);
        return this.asByteArray(snapshot.getImage());
    }

    private Capture captureStrategy() {
        if (this.environmentVariables.aValueIsDefinedFor("shutterbug.capturestrategy")) {
            return Capture.valueOf((String)this.environmentVariables.getValue("shutterbug.capturestrategy", "VIEWPORT"));
        }
        if (this.environmentVariables.aValueIsDefinedFor((Enum)ThucydidesSystemProperty.SERENITY_SCREENSHOT_STRATEGY)) {
            return Capture.valueOf((String)this.environmentVariables.getValue((Enum)ThucydidesSystemProperty.SERENITY_SCREENSHOT_STRATEGY));
        }
        if (this.environmentVariables.aValueIsDefinedFor((Enum)ThucydidesSystemProperty.SERENITY_FULL_PAGE_SCREENSHOT_STRATEGY)) {
            return ThucydidesSystemProperty.SERENITY_FULL_PAGE_SCREENSHOT_STRATEGY.booleanFrom(this.environmentVariables) != false ? Capture.FULL_SCROLL : Capture.VIEWPORT;
        }
        return Capture.VIEWPORT;
    }

    private byte[] asByteArray(BufferedImage image) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "png", outputStream);
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

