/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.jsf;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import net.sf.ahtutils.model.event.GlobalCdiEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGlobalCdiEventController {
    static final Logger logger = LoggerFactory.getLogger(AbstractGlobalCdiEventController.class);
    private final List<HttpSession> httpSessions = new ArrayList<HttpSession>();

    public void addSession(HttpSession httpSession) {
        logger.trace("addSession");
        this.httpSessions.add(httpSession);
    }

    public void removeSession(HttpSession httpSession) {
        logger.trace("removeSession");
        this.httpSessions.remove(httpSession);
    }

    public void fireEvent(GlobalCdiEvent eventObject) {
        if (logger.isTraceEnabled()) {
            logger.trace("fire: " + eventObject);
        }
        for (HttpSession session : this.httpSessions) {
            this.fireEventIntoSession(session, eventObject);
        }
    }

    private void fireEventIntoSession(HttpSession session, GlobalCdiEvent eventObject) {
        if (logger.isTraceEnabled()) {
            logger.trace("fireEventIntoSession: " + eventObject);
        }
        try {
            List<GlobalCdiEvent> globalEvents = this.getGlobalEvents(session);
            globalEvents.add(eventObject);
        }
        catch (Exception e) {
            throw new IllegalStateException("fireEvent", e);
        }
    }

    private synchronized List<GlobalCdiEvent> getGlobalEvents(HttpSession session) {
        ArrayList globalEvents = (ArrayList)session.getAttribute("HttpSessionControllerEvent");
        if (globalEvents == null) {
            globalEvents = new ArrayList();
            session.setAttribute("HttpSessionControllerEvent", globalEvents);
        }
        return globalEvents;
    }
}

