/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.jsf.components.layout;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractUtilsGrid
extends UIPanel {
    static final Logger logger = LoggerFactory.getLogger(AbstractUtilsGrid.class);
    protected int width = 70;
    protected int gutter = 5;

    protected void pushCssToHead() throws AbortProcessingException {
        StringBuffer sbCss = new StringBuffer();
        sbCss.append("grid-");
        sbCss.append(this.width).append("-").append(this.gutter);
        sbCss.append(".css");
        this.pushCssToHead(sbCss.toString());
    }

    protected void pushCssToHead(String name) {
        this.pushCssToHead("ahtutilsCss", name);
    }

    protected void pushCssToHead(String library, String name) {
        UIOutput css = new UIOutput();
        css.setRendererType("javax.faces.resource.Stylesheet");
        css.getAttributes().put("library", library);
        css.getAttributes().put("name", name);
        FacesContext context = this.getFacesContext();
        context.getViewRoot().addComponentResource(context, (UIComponent)css, "head");
    }

    protected void writeGridBegin(FacesContext context, ResponseWriter responseWriter, Map<String, Object> mapAttribute) throws IOException {
        responseWriter.startElement("div", (UIComponent)this);
        responseWriter.writeAttribute("id", (Object)this.getClientId(context), "id");
        StringBuffer sbStyleClass = new StringBuffer();
        sbStyleClass.append("auContainer");
        if (mapAttribute.containsKey(Properties.styleClass.toString())) {
            sbStyleClass.append(" ").append(mapAttribute.get(Properties.styleClass.toString()));
        }
        responseWriter.writeAttribute("class", (Object)sbStyleClass.toString(), null);
    }

    protected void writeGridEnd(ResponseWriter responseWriter) throws IOException {
        responseWriter.endElement("div");
    }

    protected static enum Properties {
        width,
        gutter,
        styleClass;

    }
}

