/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.jsf.components.layout;

import java.io.IOException;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FacesComponent(value="net.sf.ahtutils.jsf.components.layout.PanelGrid")
@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class PanelGrid
extends UIPanel {
    static final Logger logger = LoggerFactory.getLogger(PanelGrid.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (event instanceof PostAddToViewEvent) {
            UIOutput css = new UIOutput();
            css.setRendererType("javax.faces.resource.Stylesheet");
            css.getAttributes().put("library", "ahtutilsCss");
            css.getAttributes().put("name", "panelGrid.css");
            FacesContext context = this.getFacesContext();
            context.getViewRoot().addComponentResource(context, (UIComponent)css, "head");
        }
        super.processEvent(event);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter responseWriter = context.getResponseWriter();
        responseWriter.startElement("div", (UIComponent)this);
        responseWriter.writeAttribute("class", (Object)"auPanelGrid", null);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter responseWriter = context.getResponseWriter();
        responseWriter.endElement("div");
    }

    public void encodeChildren(FacesContext context) throws IOException {
        ResponseWriter responseWriter = context.getResponseWriter();
        int rows = this.getChildCount() / 2;
        if (this.getChildCount() % 2 != 0) {
            ++rows;
        }
        for (int row = 0; row < rows; ++row) {
            responseWriter.startElement("div", (UIComponent)this);
            responseWriter.writeAttribute("class", (Object)"auPanelGridRow", null);
            responseWriter.startElement("div", (UIComponent)this);
            responseWriter.writeAttribute("class", (Object)"auPgCell1", null);
            responseWriter.writeAttribute("style", (Object)"min-width:20%;", null);
            ((UIComponent)this.getChildren().get(row * 2)).encodeAll(context);
            responseWriter.endElement("div");
            responseWriter.startElement("div", (UIComponent)this);
            responseWriter.writeAttribute("class", (Object)"auPgCell2", null);
            responseWriter.writeAttribute("style", (Object)"width:80%;", null);
            ((UIComponent)this.getChildren().get(row * 2 + 1)).encodeAll(context);
            responseWriter.endElement("div");
            responseWriter.endElement("div");
        }
    }

    public static enum Properties {
        width,
        gutter,
        styleClass;

    }
}

