/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.jsf.converter;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import net.sf.ahtutils.model.interfaces.with.EjbWithCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEjbCodeConverter<I extends EjbWithCode>
implements Converter {
    static final Logger logger = LoggerFactory.getLogger(AbstractEjbCodeConverter.class);
    private Class<I> clEjb;

    public AbstractEjbCodeConverter(Class<I> clEjb) {
        this.clEjb = clEjb;
    }

    public AbstractEjbCodeConverter() {
    }

    public void setClEjb(Class<I> clEjb) {
        this.clEjb = clEjb;
    }

    public Object getAsObject(FacesContext facesContext, UIComponent component, String submittedValue) {
        if ((submittedValue = submittedValue.trim()).equals("")) {
            return null;
        }
        try {
            String[] token = submittedValue.split("-");
            long id = Long.valueOf(token[0]);
            String code = token[1];
            EjbWithCode ejb = (EjbWithCode)this.clEjb.newInstance();
            ejb.setId(id);
            ejb.setCode(code);
            return ejb;
        }
        catch (NumberFormatException e) {
            String errMsg = "NumberFormatException for " + this.clEjb.getSimpleName() + ", not a valid id (submitted: " + submittedValue + ")";
            logger.error(errMsg);
            throw new ConverterException(new FacesMessage(FacesMessage.SEVERITY_ERROR, "Conversion Error", errMsg));
        }
        catch (InstantiationException e) {
            String errMsg = "InstantiationException for " + this.clEjb.getSimpleName() + ": " + e.getMessage() + " (submitted: " + submittedValue + ")";
            logger.error(errMsg);
            throw new ConverterException(new FacesMessage(FacesMessage.SEVERITY_ERROR, "Conversion Error", errMsg));
        }
        catch (IllegalAccessException e) {
            String errMsg = "IllegalAccessException for " + this.clEjb.getSimpleName() + ": " + e.getMessage() + " (submitted: " + submittedValue + ")";
            logger.error(errMsg);
            throw new ConverterException(new FacesMessage(FacesMessage.SEVERITY_ERROR, "Conversion Error", errMsg));
        }
    }

    public String getAsString(FacesContext facesContext, UIComponent component, Object value) {
        if (value == null || value.equals("")) {
            return "";
        }
        EjbWithCode ejb = (EjbWithCode)value;
        return ejb.getId() + "-" + ejb.getCode();
    }
}

