/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.jsf.filter;

import java.util.ArrayList;
import java.util.List;
import net.sf.ahtutils.jsf.filter.UtilsStatusFilter;
import net.sf.ahtutils.model.interfaces.status.UtilsDescription;
import net.sf.ahtutils.model.interfaces.status.UtilsLang;
import net.sf.ahtutils.model.interfaces.status.UtilsStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusFilterModel<L extends UtilsLang, D extends UtilsDescription, S extends UtilsStatus<L, D>> {
    static final Logger logger = LoggerFactory.getLogger(StatusFilterModel.class);
    private List<UtilsStatusFilter<L, D, S>> list = new ArrayList<UtilsStatusFilter<L, D, S>>();

    public StatusFilterModel(List<S> data, boolean visible) {
        for (UtilsStatus s : data) {
            this.list.add(new UtilsStatusFilter(s, visible));
        }
    }

    public void toggle(UtilsStatusFilter<L, D, S> sf) {
        UtilsStatusFilter<L, D, S> sfList;
        sfList.setActive(!(sfList = this.list.get(this.list.indexOf(sf))).isActive());
    }

    public void toggle(UtilsStatus<L, D> status) {
        logger.info("Toggle: " + status);
        for (UtilsStatusFilter<L, D, S> usf : this.list) {
            if (!usf.getValue().equals(status)) continue;
            usf.setActive(!usf.isActive());
        }
    }

    public List<UtilsStatusFilter<L, D, S>> getValues() {
        return this.list;
    }

    public List<S> toSelection() {
        ArrayList<S> result = new ArrayList<S>();
        for (UtilsStatusFilter<L, D, S> sf : this.list) {
            if (!sf.isActive()) continue;
            result.add(sf.getValue());
        }
        return result;
    }
}

