/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.jsf.listener;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpSession;
import net.sf.ahtutils.jsf.util.FacesContextUtil;
import net.sf.ahtutils.model.event.GlobalCdiEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalCdiEventPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    static final Logger logger = LoggerFactory.getLogger(GlobalCdiEventPhaseListener.class);

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        HttpSession httpSession = FacesContextUtil.getHttpSession(facesContext);
        if (httpSession != null) {
            List<GlobalCdiEvent> globalEvents = this.getGlobalEvents(httpSession);
            if (!globalEvents.isEmpty()) {
                this.fireEvents(globalEvents);
            }
        } else {
            logger.warn("httpSession==null");
        }
    }

    public void afterPhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    private void fireEvents(List<GlobalCdiEvent> globalEvents) {
        BeanManager beanManager = FacesContextUtil.lookBeanManager();
        if (beanManager != null) {
            try {
                for (GlobalCdiEvent devaGlobalEvent : globalEvents) {
                    beanManager.fireEvent((Object)devaGlobalEvent, new Annotation[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("fireEvents", e);
            }
        } else {
            logger.warn("beanManager==null");
        }
    }

    private synchronized List<GlobalCdiEvent> getGlobalEvents(HttpSession httpSession) {
        List events = (List)httpSession.getAttribute("HttpSessionControllerEvent");
        ArrayList<GlobalCdiEvent> result = new ArrayList<GlobalCdiEvent>();
        if (events != null) {
            result.addAll(events);
            events.clear();
        }
        return result;
    }
}

