/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.jsf.menu;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.sf.ahtutils.exception.ejb.UtilsNotFoundException;
import net.sf.ahtutils.xml.access.Access;
import net.sf.ahtutils.xml.access.Category;
import net.sf.ahtutils.xml.access.View;
import net.sf.ahtutils.xml.navigation.Breadcrumb;
import net.sf.ahtutils.xml.navigation.Menu;
import net.sf.ahtutils.xml.navigation.MenuItem;
import net.sf.ahtutils.xml.navigation.UrlMapping;
import net.sf.ahtutils.xml.status.Lang;
import net.sf.ahtutils.xml.xpath.AccessXpath;
import net.sf.ahtutils.xml.xpath.NavigationXpath;
import net.sf.exlp.exception.ExlpXpathNotFoundException;
import net.sf.exlp.exception.ExlpXpathNotUniqueException;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuFactory {
    static final Logger logger = LoggerFactory.getLogger(MenuFactory.class);
    private String lang;
    private String contextRoot;
    private Access access;
    private boolean noRestrictions;
    private Map<String, Boolean> mapViewAllowed;
    private Map<String, Map<String, String>> translationsMenu;
    private Map<String, Map<String, String>> translationsAccess;
    private Map<String, View> mapView;
    private Map<String, MenuItem> mapMenuItems;
    private Map<String, String> mapParent;
    private String rootNode;
    private DirectedGraph<String, DefaultEdge> graph;
    private int alwaysUpToLevel;

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public MenuFactory(Menu menu, String lang) {
        this(menu, null, lang, UUID.randomUUID().toString(), true);
    }

    public MenuFactory(Menu menu, String lang, String rootNode) {
        this(menu, null, lang, rootNode, true);
    }

    public MenuFactory(Menu menu, Access access, String lang) {
        this(menu, access, lang, UUID.randomUUID().toString(), false);
    }

    public MenuFactory(Menu menu, Access access, String lang, String rootNode) {
        this(menu, access, lang, rootNode, false);
    }

    public MenuFactory(Menu menu, Access access, String lang, String rootNode, boolean noRestrictions) {
        this.access = access;
        this.rootNode = rootNode;
        this.noRestrictions = noRestrictions;
        this.translationsMenu = new Hashtable<String, Map<String, String>>();
        this.translationsAccess = new Hashtable<String, Map<String, String>>();
        this.mapMenuItems = new Hashtable<String, MenuItem>();
        this.mapParent = new Hashtable<String, String>();
        this.switchLang(lang);
        this.processMenu(menu);
        if (logger.isTraceEnabled()) {
            logger.info("Graph: " + this.graph);
            logger.info("mapMenuItems.size()" + this.mapMenuItems.size());
        }
        this.mapView = new Hashtable<String, View>();
        if (access != null) {
            this.createAccessMaps();
        }
        this.alwaysUpToLevel = 1;
    }

    private void processMenu(Menu menu) {
        this.graph = new DefaultDirectedGraph(DefaultEdge.class);
        this.graph.addVertex((Object)this.rootNode);
        logger.trace("Added Root: " + this.rootNode);
        for (MenuItem mi : menu.getMenuItem()) {
            this.processMenuItem(this.rootNode, mi);
        }
    }

    private void processMenuItem(String parentNode, MenuItem mi) {
        this.mapParent.put(mi.getCode(), parentNode);
        this.graph.addVertex((Object)mi.getCode());
        this.graph.addEdge((Object)parentNode, (Object)mi.getCode());
        logger.trace("Added Vertex: " + mi.getCode());
        if (mi.isSetLangs()) {
            for (Lang l : mi.getLangs().getLang()) {
                this.checkLang(l.getKey());
                this.translationsMenu.get(l.getKey()).put(mi.getCode(), l.getTranslation());
            }
        }
        for (MenuItem miChild : mi.getMenuItem()) {
            this.processMenuItem(mi.getCode(), miChild);
        }
        mi.getMenuItem().clear();
        this.mapMenuItems.put(mi.getCode(), mi);
    }

    public void setAlwaysUpToLevel(int alwaysUpToLevel) {
        this.alwaysUpToLevel = alwaysUpToLevel;
    }

    private void createAccessMaps() {
        for (Category c : this.access.getCategory()) {
            if (!c.isSetViews()) continue;
            for (View v : c.getViews().getView()) {
                this.mapView.put(v.getCode(), v);
                if (!v.isSetLangs()) continue;
                for (Lang l : v.getLangs().getLang()) {
                    this.checkLang(l.getKey());
                    this.translationsAccess.get(l.getKey()).put(v.getCode(), l.getTranslation());
                }
            }
        }
    }

    public Menu build() {
        this.noRestrictions = true;
        return this.build(null, this.rootNode);
    }

    public Menu build(String codeCurrent) {
        return this.build(null, codeCurrent);
    }

    public Menu build(Map<String, Boolean> mapViewAllowed) {
        return this.build(mapViewAllowed, this.rootNode);
    }

    public Menu build(Map<String, Boolean> mapViewAllowed, String codeCurrent) {
        return this.build(mapViewAllowed, codeCurrent, false);
    }

    public Menu build(Map<String, Boolean> mapViewAllowed, String codeCurrent, boolean isLoggedIn) {
        logger.trace("Building (" + this.rootNode + "): " + codeCurrent);
        this.mapViewAllowed = mapViewAllowed;
        Menu result = new Menu();
        try {
            result.getMenuItem().addAll(this.processChilds(1, this.rootNode, codeCurrent, isLoggedIn));
        }
        catch (UtilsNotFoundException e) {
            logger.warn(e.getMessage());
        }
        return result;
    }

    private List<MenuItem> processChilds(int level, String node, String codeCurrent, boolean isLoggedIn) throws UtilsNotFoundException {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        for (DefaultEdge edge : this.graph.outgoingEdgesOf((Object)node)) {
            MenuItem miAdd = null;
            MenuItem mi = this.mapMenuItems.get(this.graph.getEdgeTarget((Object)edge));
            if (mi.isSetView()) {
                if (!this.mapView.containsKey(mi.getView().getCode())) {
                    throw new UtilsNotFoundException("No view with code=" + mi.getView().getCode());
                }
                View view = this.mapView.get(mi.getView().getCode());
                if (this.noRestrictions || view.isPublic() || view.isSetOnlyLoginRequired() && view.isOnlyLoginRequired() && isLoggedIn || this.mapViewAllowed != null && this.mapViewAllowed.containsKey(mi.getView().getCode()) && this.mapViewAllowed.get(mi.getView().getCode()).booleanValue()) {
                    miAdd = this.processItem(mi, codeCurrent, view);
                }
            } else {
                miAdd = this.processItem(mi, codeCurrent, null);
            }
            if (miAdd == null) continue;
            if (mi.getCode().equals(codeCurrent)) {
                miAdd.setActive(true);
            } else {
                miAdd.setActive(false);
            }
            boolean currentIsChild = false;
            List path = null;
            try {
                DijkstraShortestPath dsp = new DijkstraShortestPath(this.graph, (Object)mi.getCode(), (Object)codeCurrent);
                path = dsp.getPathEdgeList();
            }
            catch (IllegalArgumentException e) {
                logger.error("Error in graph from " + mi.getCode() + " to " + codeCurrent);
                logger.error(e.getMessage());
            }
            if (path != null) {
                currentIsChild = true;
                miAdd.setActive(true);
            }
            if (level < this.alwaysUpToLevel || currentIsChild) {
                miAdd.getMenuItem().addAll(this.processChilds(level + 1, mi.getCode(), codeCurrent, isLoggedIn));
            }
            this.mapMenuItems.get(miAdd.getCode()).setName(miAdd.getName());
            this.mapMenuItems.get(miAdd.getCode()).setHref(miAdd.getHref());
            result.add(miAdd);
        }
        return result;
    }

    private MenuItem processItem(MenuItem miOrig, String codeCurrent, View view) throws UtilsNotFoundException {
        MenuItem mi = new MenuItem();
        mi.setCode(miOrig.getCode());
        if (miOrig.isSetLangs()) {
            mi.setName(this.getNameFromMenuItem(miOrig.getCode()));
        } else if (miOrig.isSetView()) {
            mi.setName(this.getNameFromViews(view, miOrig.getView()));
        } else {
            logger.warn("Translation missing!!");
            mi.setName("Translation missing");
        }
        if (miOrig.isSetHref()) {
            mi.setHref(miOrig.getHref());
        } else if (miOrig.isSetView()) {
            mi.setHref(this.getHrefFromViews(miOrig.getView()));
        }
        return mi;
    }

    private String getNameFromMenuItem(String code) {
        if (!this.translationsMenu.containsKey(this.lang)) {
            return "???no-lang-for-" + this.lang + "???";
        }
        if (!this.translationsMenu.get(this.lang).containsKey(code)) {
            return "???" + code + "???";
        }
        return this.translationsMenu.get(this.lang).get(code);
    }

    private String getNameFromViews(View view, View viewCode) {
        StringBuffer sbLabel = new StringBuffer();
        if (!this.translationsAccess.containsKey(this.lang)) {
            return "???no-lang-for-" + this.lang + "???";
        }
        if (!this.translationsAccess.get(this.lang).containsKey(view.getCode())) {
            sbLabel.append("???" + view.getCode() + "???");
        } else {
            sbLabel.append(this.translationsAccess.get(this.lang).get(view.getCode()));
        }
        if (viewCode.isSetLabel()) {
            if (sbLabel.length() > 0) {
                sbLabel.append(" ");
            }
            sbLabel.append(viewCode.getLabel());
        }
        return sbLabel.toString();
    }

    private String getHrefFromViews(View viewCode) {
        try {
            View view = AccessXpath.getView((Access)this.access, (String)viewCode.getCode());
            if (view.isSetNavigation() && view.getNavigation().isSetUrlMapping()) {
                UrlMapping urlMapping = view.getNavigation().getUrlMapping();
                StringBuffer sb = new StringBuffer();
                if (this.contextRoot != null) {
                    sb.append("/").append(this.contextRoot);
                }
                if (urlMapping.isSetUrl()) {
                    sb.append(urlMapping.getUrl());
                    if (viewCode.isSetUrlParameter()) {
                        sb.append(viewCode.getUrlParameter());
                    }
                } else {
                    sb.append(urlMapping.getValue());
                }
                return sb.toString();
            }
        }
        catch (ExlpXpathNotFoundException e) {
        }
        catch (ExlpXpathNotUniqueException exlpXpathNotUniqueException) {
            // empty catch block
        }
        return null;
    }

    public void removeChilds(String dynamicRoot, String dynKey) {
        Iterator iterator = this.graph.outgoingEdgesOf((Object)dynamicRoot).iterator();
        ArrayList<DefaultEdge> list = new ArrayList<DefaultEdge>();
        while (iterator.hasNext()) {
            DefaultEdge edge = (DefaultEdge)iterator.next();
            String target = (String)this.graph.getEdgeTarget((Object)edge);
            if (!target.startsWith(dynKey)) continue;
            list.add(edge);
        }
        this.graph.removeAllEdges(list);
    }

    private void removeEdgeToTemplate(String dynamicRoot, String templateNode) {
        Iterator iterator = this.graph.getAllEdges((Object)dynamicRoot, (Object)templateNode).iterator();
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        this.graph.removeAllEdges(list);
    }

    public void addDynamicNodes(Menu dynamicMenu) {
        for (MenuItem mi : dynamicMenu.getMenuItem()) {
            this.removeEdgeToTemplate(dynamicMenu.getCode(), mi.getView().getCode());
            this.graph.addVertex((Object)mi.getCode());
            this.graph.addEdge((Object)dynamicMenu.getCode(), (Object)mi.getCode());
            this.mapMenuItems.put(mi.getCode(), mi);
        }
    }

    public Breadcrumb breadcrumb(String code) {
        return this.breadcrumb(false, code);
    }

    public Breadcrumb breadcrumb(boolean withRoot, String code) {
        Breadcrumb result = new Breadcrumb();
        try {
            DijkstraShortestPath dsp = new DijkstraShortestPath(this.graph, (Object)this.rootNode, (Object)code);
            List path = dsp.getPathEdgeList();
            if (path.size() > 0) {
                result.getMenuItem().add(this.mapMenuItems.get(this.graph.getEdgeSource(path.get(0))));
            }
            for (DefaultEdge de : path) {
                String src = (String)this.graph.getEdgeTarget((Object)de);
                result.getMenuItem().add(this.mapMenuItems.get(src));
            }
            if (!withRoot) {
                result.getMenuItem().remove(0);
            }
        }
        catch (IllegalArgumentException e) {
            logger.error("Breadcrumb from " + this.rootNode + "->" + code + " " + e.getMessage());
            logger.error(this.graph.toString());
        }
        return result;
    }

    public MenuItem subMenu(Menu menu, String code) {
        MenuItem result;
        try {
            if (code.equals(this.rootNode)) {
                MenuItem result2 = new MenuItem();
                result2.getMenuItem().addAll(menu.getMenuItem());
                return result2;
            }
            result = NavigationXpath.getMenuItem((Menu)menu, (String)code);
        }
        catch (ExlpXpathNotFoundException e) {
            result = new MenuItem();
        }
        catch (ExlpXpathNotUniqueException e) {
            result = new MenuItem();
        }
        return result;
    }

    public void switchLang(String lang) {
        this.lang = lang;
    }

    private void checkLang(String checkLanguage) {
        if (!this.translationsMenu.containsKey(checkLanguage)) {
            this.translationsMenu.put(checkLanguage, new Hashtable());
        }
        if (!this.translationsAccess.containsKey(checkLanguage)) {
            this.translationsAccess.put(checkLanguage, new Hashtable());
        }
    }

    public String getParent(String code) {
        return this.mapParent.get(code);
    }
}

