/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.jsf.util;

import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentVisibleManager<E extends Enum<E>> {
    static final Logger logger = LoggerFactory.getLogger(ComponentVisibleManager.class);
    private Map<String, Boolean> visible = new Hashtable<String, Boolean>();

    public ComponentVisibleManager(Class<E> e) {
        for (Enum v : (Enum[])e.getEnumConstants()) {
            logger.trace("construct with " + v);
        }
    }

    public void clear() {
        this.visible.clear();
    }

    private void verifyFalse(E e) {
        if (!this.visible.containsKey(((Enum)e).toString())) {
            this.visible.put(((Enum)e).toString(), false);
        }
    }

    public void edit(E e, boolean value) {
        this.edit(((Enum)e).toString(), value);
    }

    public void edit(String key, boolean value) {
        logger.trace("edit key:" + key + " value:" + value);
        this.visible.put(key, value);
    }

    public Map<String, Boolean> getVisible() {
        return this.visible;
    }

    public boolean isShow(E e) {
        this.verifyFalse(e);
        return this.visible.get(((Enum)e).toString());
    }

    public void toggle(E e) {
        this.verifyFalse(e);
        if (this.visible.get(((Enum)e).toString()).booleanValue()) {
            this.edit(e, false);
        } else {
            this.edit(e, true);
        }
    }
}

