/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.jsf.util;

import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.ahtutils.exception.ejb.UtilsNotFoundException;

public class FacesContextUtil {
    public static String get(String key) throws UtilsNotFoundException {
        if (FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().containsKey(key)) {
            return (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get(key);
        }
        throw new UtilsNotFoundException("HTTP Request Paramater '" + key + "' not available");
    }

    public static HttpServletRequest getHttpServletRequest(FacesContext facesContext) {
        Object request = facesContext.getExternalContext().getRequest();
        if (request instanceof HttpServletRequest) {
            return (HttpServletRequest)request;
        }
        return null;
    }

    public static HttpSession getHttpSession(FacesContext facesContext) {
        HttpServletRequest httpServletRequest = FacesContextUtil.getHttpServletRequest(facesContext);
        if (httpServletRequest != null) {
            return httpServletRequest.getSession();
        }
        return null;
    }

    public static BeanManager lookBeanManager() {
        try {
            Object obj = new InitialContext().lookup("java:comp/BeanManager");
            return (BeanManager)obj;
        }
        catch (Exception e) {
            throw new IllegalStateException("Lookup bean manager", e);
        }
    }
}

