/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.model.primefaces;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.model.ListDataModel;
import net.sf.ahtutils.jsf.interfaces.dm.DmAllSelect;
import net.sf.ahtutils.jsf.interfaces.dm.DmSingleSelect;
import net.sf.ahtutils.model.interfaces.with.EjbWithId;
import org.primefaces.model.SelectableDataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimefacesEjbIdDataModel<T extends EjbWithId>
extends ListDataModel<T>
implements SelectableDataModel<T> {
    static final Logger logger = LoggerFactory.getLogger(PrimefacesEjbIdDataModel.class);
    private boolean details = false;
    private Map<Long, Boolean> mapUnlock = new Hashtable<Long, Boolean>();
    private Map<Long, Boolean> mapSelect = new Hashtable<Long, Boolean>();
    private Map<Long, Boolean> mapInfo = new Hashtable<Long, Boolean>();
    private DmSingleSelect<T> singleSelectCallback;
    private DmAllSelect<T> allSelectCallback;

    public PrimefacesEjbIdDataModel(List<T> data) {
        super(data);
        for (EjbWithId t : data) {
            this.mapUnlock.put(t.getId(), false);
            this.mapSelect.put(t.getId(), false);
            this.mapInfo.put(t.getId(), false);
        }
    }

    public T getRowData(String rowKey) {
        List list = (List)this.getWrappedData();
        for (EjbWithId ejb : list) {
            if (ejb.getId() != (long)new Integer(rowKey).intValue()) continue;
            return (T)ejb;
        }
        return null;
    }

    public Object getRowKey(T item) {
        return item.getId();
    }

    public void unlock(T item) {
        this.mapUnlock.put(item.getId(), true);
    }

    public void unlock(T item, boolean value) {
        this.mapUnlock.put(item.getId(), value);
    }

    public void info(T item, boolean value) {
        this.mapInfo.put(item.getId(), value);
    }

    public void toggleSelection(T item) {
        if (!this.mapSelect.containsKey(item.getId())) {
            this.select(item, false);
        } else if (this.mapSelect.get(item.getId()).booleanValue()) {
            this.select(item, false);
        } else {
            this.select(item, true);
        }
    }

    public void select(T item, boolean value) {
        this.select(item, value, true);
    }

    public void select(T item, boolean value, boolean withCallback) {
        this.mapSelect.put(item.getId(), value);
        if (withCallback && this.singleSelectCallback != null) {
            this.singleSelectCallback.dmSingleSelected(item);
        }
    }

    public void selectAll(boolean value) {
        for (long key : this.mapSelect.keySet()) {
            this.mapSelect.put(key, value);
        }
        if (this.allSelectCallback != null) {
            this.allSelectCallback.dmAllSelected();
        }
    }

    public void update(T item) {
        List list = (List)this.getWrappedData();
        int index = list.indexOf(item);
        list.set(index, item);
        this.setWrappedData(list);
        this.setRowIndex(index);
    }

    public Map<Long, Boolean> getMapUnlock() {
        return this.mapUnlock;
    }

    public Map<Long, Boolean> getMapSelect() {
        return this.mapSelect;
    }

    public Map<Long, Boolean> getMapInfo() {
        return this.mapInfo;
    }

    public boolean isSelected(long id) {
        if (this.mapSelect.containsKey(id)) {
            return this.mapSelect.get(id);
        }
        return false;
    }

    public List<T> toData() {
        ArrayList allData = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            allData.add(iterator.next());
        }
        return allData;
    }

    public List<T> toSelection() {
        ArrayList<EjbWithId> listSelected = new ArrayList<EjbWithId>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EjbWithId t = (EjbWithId)iterator.next();
            if (!this.mapSelect.get(t.getId()).booleanValue()) continue;
            listSelected.add(t);
        }
        return listSelected;
    }

    public void setSingleSelectCallback(DmSingleSelect<T> singleSelectCallback) {
        this.singleSelectCallback = singleSelectCallback;
    }

    public void setAllSelectCallback(DmAllSelect<T> allSelectCallback) {
        this.allSelectCallback = allSelectCallback;
    }

    public boolean contains(T t) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (t.getId() != ((EjbWithId)iterator.next()).getId()) continue;
            return true;
        }
        return false;
    }

    public boolean isDetails() {
        return this.details;
    }

    public void setDetails(boolean details) {
        this.details = details;
    }

    public void toggleDetails() {
        this.details = !this.details;
        logger.trace("Toggled details to " + this.details);
    }
}

