/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.msgbundle;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;

public class Utf8ResourceBundle
extends ResourceBundle {
    protected static final String bundleExtension = "properties";
    protected static final ResourceBundle.Control UTF8_CONTROL = new UTF8Control();

    public Utf8ResourceBundle(String bundleName) {
        this.setParent(ResourceBundle.getBundle(bundleName, FacesContext.getCurrentInstance().getViewRoot().getLocale(), UTF8_CONTROL));
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.parent.getObject(key);
    }

    public Enumeration getKeys() {
        return this.parent.getKeys();
    }

    protected static class UTF8Control
    extends ResourceBundle.Control {
        protected UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, Utf8ResourceBundle.bundleExtension);
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, "UTF-8"));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

